/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.data.connections.downloader.douban;

import com.recalot.common.communication.InnerIds;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.Relation;
import com.recalot.common.communication.User;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.model.data.connections.downloader.BaseDownloaderDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class DoubanDataSource
extends BaseDownloaderDataSource {
    public void connect() throws BaseException {
        String source = "douban";
        File folder = null;
        try {
            folder = this.downloadData(source, "https://dl.dropboxusercontent.com/u/17517913/Douban.zip");
            File trustFile = null;
            File ratingsFile = null;
            String dirPath = "";
            for (File file : folder.listFiles()) {
                String name = file.getName().toLowerCase();
                if (name.toLowerCase().equals("uir.index")) {
                    ratingsFile = file;
                    continue;
                }
                if (!name.toLowerCase().equals("social.index")) continue;
                trustFile = file;
            }
            if (trustFile == null || ratingsFile == null) {
                throw new NotFoundException("Can not find necessary files in '%s'.", dirPath);
            }
            this.setInfo("Read Interactions");
            this.readRatingsFile(ratingsFile);
            this.setInfo("Read Trust");
            this.readTrustFile(trustFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setInfo("Done");
    }

    private void readRatingsFile(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            int i = 0;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(" ");
                if (split.length != 3) continue;
                String ratingId = "" + i++;
                String userId = split[0].intern();
                String itemId = split[1].intern();
                if (!this.users.containsKey(InnerIds.getNextId((String)userId))) {
                    this.users.put(InnerIds.getNextId((String)userId), new User(userId));
                }
                if (!this.items.containsKey(InnerIds.getNextId((String)itemId))) {
                    this.items.put(InnerIds.getNextId((String)itemId), new Item(itemId));
                }
                this.interactions.put(InnerIds.getNextId((String)ratingId), new Interaction(ratingId, userId, itemId, null, "rating".intern(), split[2].intern(), null));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    private void readTrustFile(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            int i = 0;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(" ");
                if (split.length != 2) continue;
                String userId1 = split[0];
                String userId2 = split[1];
                String id = InnerIds.decTo36base((int)i++);
                this.relations.put(InnerIds.getNextId((String)id), new Relation(id, userId1, userId2, "friendship".intern(), null));
                id = InnerIds.decTo36base((int)i++);
                this.relations.put(InnerIds.getNextId((String)id), new Relation(id, userId2, userId1, "friendship".intern(), null));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
    }
}

