/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.data.connections.downloader.flixster;

import com.recalot.common.Helper;
import com.recalot.common.communication.InnerIds;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.Relation;
import com.recalot.common.communication.User;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.model.data.connections.downloader.BaseDownloaderDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;

public class FlixsterDataSource
extends BaseDownloaderDataSource {
    public void connect() throws BaseException {
        String source = "flixster";
        File folder = null;
        try {
            folder = this.downloadData(source, "http://www.cs.ubc.ca/~jamalim/datasets/flixster.zip");
            File trustFile = null;
            File ratingsFile = null;
            String dirPath = "";
            for (File dir : folder.listFiles()) {
                if (!dir.getName().toLowerCase().equals("flixster-dataset")) continue;
                for (File dir2 : dir.listFiles()) {
                    if (!dir2.getName().toLowerCase().equals("data")) continue;
                    for (File file : dir2.listFiles()) {
                        String name = file.getName().toLowerCase();
                        if (name.toLowerCase().equals("nodes.csv")) {
                            ratingsFile = file;
                            continue;
                        }
                        if (!name.toLowerCase().equals("edges.csv")) continue;
                        trustFile = file;
                    }
                }
            }
            if (trustFile == null || ratingsFile == null) {
                throw new NotFoundException("Can not find necessary files in '%s'.", dirPath);
            }
            this.setInfo("Read Interactions");
            this.readRatingsFile(ratingsFile);
            this.setInfo("Read Trust");
            this.readTrustFile(trustFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setInfo("Done");
    }

    private void readRatingsFile(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            int i = 0;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(" ");
                if (split.length != 3) continue;
                String ratingId = "" + i++;
                String userId = split[0];
                String itemId = split[1];
                if (!this.users.containsKey(InnerIds.getNextId((String)userId))) {
                    this.users.put(InnerIds.getNextId((String)userId), new User(userId));
                }
                if (!this.items.containsKey(InnerIds.getNextId((String)itemId))) {
                    this.items.put(InnerIds.getNextId((String)itemId), new Item(itemId));
                }
                this.interactions.put(InnerIds.getNextId((String)ratingId), new Interaction(ratingId, userId, itemId, new Date(), "rating".intern(), split[2].intern(), null));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    private void readTrustFile(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            int i = 0;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(" ");
                if (split.length != 3) continue;
                String trustor = split[0];
                String trustee = split[1];
                String trustValue = split[2];
                HashMap<String, String> content = new HashMap<String, String>();
                content.put(Helper.Keys.Value, trustValue);
                String id = "" + i++;
                this.relations.put(InnerIds.getNextId((String)id), new Relation(id, trustor, trustee, "trust".intern(), content));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
    }
}

