/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.data.connections.downloader.jester;

import com.recalot.common.communication.DataSet;
import com.recalot.common.communication.InnerIds;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.User;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.model.data.connections.downloader.BaseDownloaderDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;

@Configuration(key="source", type=ConfigurationItem.ConfigurationItemType.Options, options={"jester-1", "jester-2", "jester-3", "combined"})
public class JesterDataSource
extends BaseDownloaderDataSource {
    private String source;
    private DataSet dataSet;

    public void setSource(String source) {
        this.source = source;
    }

    public void connect() throws BaseException {
        try {
            File folder = this.downloadData("jester", "http://recalot.com/downloads/jester-data.zip");
            String fileName = "jester-data-1";
            if (this.source != null && !this.source.isEmpty()) {
                switch (this.source) {
                    case "jester-1": {
                        this.readData(folder, "jester-data-1.csv");
                        break;
                    }
                    case "jester-2": {
                        this.readData(folder, "jester-data-2.csv");
                        break;
                    }
                    case "jester-3": {
                        this.readData(folder, "jester-data-3.csv");
                        break;
                    }
                    default: {
                        this.readAllData(folder);
                    }
                }
            }
            this.setInfo("Done");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readData(File folder, String fileName) throws IOException, NotFoundException {
        File csvFile = null;
        for (File file : folder.listFiles()) {
            if (!file.getName().toLowerCase().equals(fileName)) continue;
            csvFile = file;
            break;
        }
        if (csvFile == null) {
            throw new NotFoundException("Can not find necessary files in '%s'.", folder.getAbsolutePath());
        }
        this.setInfo("Read Data");
        this.readRatingsFile(csvFile, 0);
    }

    private void readAllData(File folder) throws IOException, NotFoundException {
        this.setInfo("Read Data");
        for (File file : folder.listFiles()) {
            if (!file.getName().toLowerCase().endsWith(".csv")) continue;
            this.readRatingsFile(file, this.users.size());
        }
    }

    private void readRatingsFile(File file, int startId) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line = null;
            int i = startId;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(";");
                String userId = "" + i;
                for (int j = 1; j < split.length; ++j) {
                    NumberFormat format;
                    Number number;
                    Double value;
                    String itemId = "" + j;
                    if (!this.items.containsKey(InnerIds.getNextId((String)itemId))) {
                        this.items.put(InnerIds.getNextId((String)itemId), new Item(itemId));
                    }
                    if (!this.users.containsKey(InnerIds.getNextId((String)userId))) {
                        this.users.put(InnerIds.getNextId((String)userId), new User(userId));
                    }
                    if ((value = Double.valueOf((number = (format = NumberFormat.getInstance(Locale.FRANCE)).parse(split[j])).doubleValue())).isNaN() || value == 99.0) continue;
                    String ratingId = "" + this.interactions.size();
                    this.interactions.put(InnerIds.getNextId((String)ratingId), new Interaction(ratingId, userId, itemId, null, "rating".intern(), "" + value, new HashMap()));
                }
                ++i;
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
    }
}

