/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.data.connections.reddit;

import com.recalot.common.communication.InnerIds;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.User;
import com.recalot.common.exceptions.BaseException;
import com.recalot.model.data.connections.base.DataSourceBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringEscapeUtils;

public class RedditDataSource
extends DataSourceBase {
    private File dir;
    private float interactionId = 0.0f;
    private boolean initialized = false;
    private List<Interaction> sortedInteractions = null;

    public void connect() throws BaseException {
        if (this.dir != null && this.dir.exists()) {
            for (File userFile : this.dir.listFiles()) {
                if (!userFile.getName().endsWith(".csv")) continue;
                String userName = this.createNewUser(userFile.getName());
                this.readFile(userName, userFile);
            }
            this.initialized = true;
        }
    }

    private void readFile(String userName, File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                int i = 0;
                String[] split = line.split("00;");
                if (split.length != 2) continue;
                Date date = DatatypeConverter.parseDateTime((String)(split[0] + "00")).getTime();
                List<String> words = this.splitIntoWords(split[1]);
                for (String word : words) {
                    this.addNewItem(word.intern());
                    float f = this.interactionId;
                    this.interactionId = f + 1.0f;
                    this.addWordInteraction(userName.intern(), word.intern(), f + "", date, i++);
                }
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    private void addWordInteraction(String user, String word, String id, Date date, int i) {
        this.interactions.put(InnerIds.getNextId((String)id), new Interaction(id, user, word, new Date(date.getTime() + (long)i), "view".intern(), "1".intern(), new HashMap()));
    }

    private List<String> splitIntoWords(String sentence) {
        ArrayList<String> words = new ArrayList<String>();
        sentence = StringEscapeUtils.unescapeHtml4((String)sentence);
        String[] parts = sentence.split("(?<!^)\\b");
        String last = null;
        boolean concat = false;
        for (String word : parts) {
            if (last != null) {
                if (word.trim().length() == 0) {
                    words.add(last.trim().toLowerCase().intern());
                    last = null;
                    continue;
                }
                if (!concat && !word.equals("'") && last != null) {
                    words.add(last.trim().toLowerCase().intern());
                    last = word;
                    continue;
                }
                if (word.equals("'")) {
                    concat = true;
                    last = last + word;
                    continue;
                }
                last = concat ? last + word : word;
                concat = false;
                continue;
            }
            last = word;
        }
        if (last != null) {
            words.add(last.trim().intern());
        }
        return words;
    }

    private void addNewItem(String word) {
        if (!this.items.containsKey(InnerIds.getNextId((String)(word = word.intern())))) {
            this.items.put(InnerIds.getNextId((String)word), new Item(word));
        }
    }

    private String createNewUser(String name) {
        String userName = name.substring(0, name.length() - 4).intern();
        if (!this.users.containsKey(InnerIds.getNextId((String)userName))) {
            this.users.put(InnerIds.getNextId((String)userName), new User(userName));
        }
        return userName;
    }

    public void close() throws IOException {
    }

    @Override
    public Interaction[] getInteractions() throws BaseException {
        if (this.initialized) {
            if (this.sortedInteractions == null) {
                this.sortedInteractions = new ArrayList(this.interactions.values());
                Collections.sort(this.sortedInteractions, (a2, a1) -> a2.getTimeStamp().compareTo(a1.getTimeStamp()));
            }
            return this.sortedInteractions.toArray(new Interaction[this.sortedInteractions.size()]);
        }
        return new Interaction[0];
    }

    public void setDir(String file) {
        this.dir = new File(file);
    }
}

