/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.common.configuration;

import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.MissingArgumentException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Configurable {
    protected HashMap<String, ConfigurationItem> configurationMap = new HashMap();

    public ConfigurationItem[] getConfiguration() {
        return this.configurationMap.values().toArray(new ConfigurationItem[this.configurationMap.size()]);
    }

    public void setConfiguration(List<ConfigurationItem> configuration) {
        this.configurationMap = new HashMap();
        if (configuration != null) {
            for (ConfigurationItem item : configuration) {
                this.configurationMap.put(item.getKey(), item);
            }
        }
    }

    public ConfigurationItem getConfiguration(String key) {
        return this.configurationMap.get(key);
    }

    public void setConfiguration(ConfigurationItem configuration) {
        this.configurationMap.put(configuration.getKey(), configuration);
    }

    public void checkConfiguration(Map<String, String> config) throws BaseException {
        this.checkConfiguration("", config);
    }

    public void checkConfiguration(String prefix, Map<String, String> config) throws BaseException {
        if (this.configurationMap != null && config != null) {
            for (ConfigurationItem item : this.configurationMap.values()) {
                if (item.getRequirement() == ConfigurationItem.ConfigurationItemRequirementType.Required && !config.containsKey(prefix + item.getKey())) {
                    throw new MissingArgumentException("The argument %s is missing.", prefix + item.getKey());
                }
                if (!config.containsKey(prefix + item.getKey())) continue;
                item.setValue(config.get(prefix + item.getKey()));
            }
        }
    }

    public static void applyConfiguration(Object instance, Class c, ConfigurationItem[] config) throws Exception {
        for (ConfigurationItem item : config) {
            Method m;
            if (item.getValue() == null) continue;
            String methodName = item.getKey();
            methodName = Configurable.adjustMethodName(methodName);
            boolean found = false;
            switch (item.getType()) {
                case Integer: {
                    m = Configurable.getMethod(c, methodName, Integer.class);
                    if (m == null) {
                        m = Configurable.getMethod(c, methodName, Integer.TYPE);
                    }
                    if (m == null) break;
                    m.invoke(instance, Integer.parseInt(item.getValue()));
                    found = true;
                    break;
                }
                case Double: {
                    m = Configurable.getMethod(c, methodName, Double.class);
                    if (m == null) {
                        m = Configurable.getMethod(c, methodName, Double.TYPE);
                    }
                    if (m == null) break;
                    m.invoke(instance, Double.parseDouble(item.getValue()));
                    found = true;
                    break;
                }
                case Boolean: {
                    m = Configurable.getMethod(c, methodName, Boolean.class);
                    if (m == null) {
                        m = Configurable.getMethod(c, methodName, Boolean.TYPE);
                    }
                    if (m == null) break;
                    m.invoke(instance, Boolean.parseBoolean(item.getValue()));
                    found = true;
                    break;
                }
                case Options: 
                case String: {
                    m = Configurable.getMethod(c, methodName, String.class);
                    if (m == null) break;
                    m.invoke(instance, item.getValue());
                    found = true;
                    break;
                }
            }
            if (found || (m = Configurable.getMethod(c, "setConfigurationValue", ConfigurationItem.class)) == null) continue;
            m.invoke(instance, item);
        }
    }

    protected static Method getMethod(Class c, String methodName, Class ... cl) {
        Method m = null;
        Class tempClass = c;
        while (tempClass != null && m == null) {
            try {
                m = tempClass.getMethod(methodName, cl);
            }
            catch (NoSuchMethodException e) {
                tempClass = tempClass.getSuperclass();
            }
        }
        return m;
    }

    protected static Field getField(Class c, String fieldName, Class cl) {
        Field f = null;
        Class tempClass = c;
        while (tempClass != null && f == null) {
            try {
                f = tempClass.getDeclaredField(fieldName);
                if (!f.getType().equals(cl)) {
                    f = null;
                }
                if (f.isAccessible()) continue;
                f = null;
            }
            catch (NoSuchFieldException e) {
                tempClass = tempClass.getSuperclass();
            }
        }
        return f;
    }

    private static String adjustMethodName(String methodName) {
        String[] split;
        StringBuilder builder = new StringBuilder();
        builder.append("set");
        for (String s : split = methodName.split("-")) {
            builder.append(s.substring(0, 1).toUpperCase() + s.substring(1));
        }
        return builder.toString();
    }

    public void appendConfiguration(ArrayList<ConfigurationItem> items) {
        if (items != null && items != null) {
            for (ConfigurationItem item : items) {
                this.configurationMap.put(item.getKey(), item);
            }
        }
    }
}

