/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.common.interfaces.model.rec;

import com.recalot.common.Helper;
import com.recalot.common.communication.DataSet;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.configuration.Configurable;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.rec.RecommenderInformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Recommender
extends Configurable
implements RecommenderInformation {
    protected String dataSourceId;
    protected String recommenderId;
    protected String experimentId;
    protected RecommenderInformation.RecommenderState state;
    protected String key;
    protected DataSet dataSet;

    @Override
    public RecommenderInformation.RecommenderState getState() {
        return this.state;
    }

    public void setState(RecommenderInformation.RecommenderState state) {
        this.state = state;
    }

    @Override
    public String getId() {
        return this.recommenderId;
    }

    public void setId(String recommenderId) {
        this.recommenderId = recommenderId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(String experimentId) {
        this.experimentId = experimentId;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public abstract void train() throws BaseException;

    public RecommendationResult recommend(String userId) throws BaseException {
        return this.recommend(userId, new HashMap<String, String>());
    }

    public RecommendationResult recommend(String userId, Map<String, String> param) throws BaseException {
        return this.recommend(userId, null, param);
    }

    public RecommendationResult recommend(String userId, ContextProvider context) throws BaseException {
        return this.recommend(userId, context, new HashMap<String, String>());
    }

    public abstract RecommendationResult recommend(String var1, ContextProvider var2, Map<String, String> var3) throws BaseException;

    public Double predict(String userId, String itemId) throws BaseException {
        return this.predict(userId, itemId, new HashMap<String, String>());
    }

    public Double predict(String userId, String itemId, Map<String, String> param) throws BaseException {
        return this.predict(userId, itemId, null, param);
    }

    public Double predict(String userId, String itemId, ContextProvider context) throws BaseException {
        return this.predict(userId, itemId, context, new HashMap<String, String>());
    }

    public abstract Double predict(String var1, String var2, ContextProvider var3, Map<String, String> var4) throws BaseException;

    public List<String> recommendItemsByRatingPrediction(String userId, boolean omitVisited) throws BaseException {
        return this.recommendItemsByRatingPrediction(userId, this.getDataSet().getItems(), omitVisited);
    }

    public List<String> recommendItemsByRatingPrediction(String userId, Item[] items, boolean omitVisited) throws BaseException {
        ArrayList<String> result = new ArrayList<String>();
        Interaction[] interactions = this.getDataSet().getInteractions(userId);
        if (interactions == null || interactions.length == 0) {
            return Collections.emptyList();
        }
        List<Interaction> interactionList = Arrays.asList(interactions);
        HashMap<String, Boolean> visited = new HashMap<String, Boolean>();
        if (omitVisited) {
            for (Interaction interaction : interactionList) {
                if (visited.containsKey(interaction.getItemId())) continue;
                visited.put(interaction.getItemId(), true);
            }
        }
        Map<String, Double> predictions = new HashMap();
        for (Item item : items) {
            double pred;
            if (visited.containsKey(item.getId()) || Double.isNaN(pred = this.predict(userId, item.getId()).doubleValue())) continue;
            predictions.put(item.getId(), pred);
        }
        predictions = Helper.sortByValueDescending(predictions);
        for (String item : predictions.keySet()) {
            result.add(item);
        }
        return result;
    }
}

