/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.experiments.access;

import com.recalot.common.GenericServiceListener;
import com.recalot.common.Helper;
import com.recalot.common.builder.RecommenderBuilder;
import com.recalot.common.communication.Message;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.AlreadyExistsException;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.MissingArgumentException;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.common.exceptions.WrongFormatException;
import com.recalot.common.impl.experiment.StorageExperiment;
import com.recalot.common.interfaces.model.data.DataSource;
import com.recalot.common.interfaces.model.experiment.DataSplitter;
import com.recalot.common.interfaces.model.experiment.Experiment;
import com.recalot.common.interfaces.model.experiment.Metric;
import com.recalot.common.interfaces.model.experiment.OnlineExperiment;
import com.recalot.common.interfaces.model.rec.Recommender;
import com.recalot.common.interfaces.model.rec.RecommenderAccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.osgi.framework.BundleContext;

public class ExperimentAccess
implements com.recalot.common.interfaces.model.experiment.ExperimentAccess {
    private final BundleContext context;
    private final ConcurrentHashMap<String, Experiment> experiments;
    private final ConcurrentHashMap<String, OnlineExperiment> onlineExperiments;
    private final ConcurrentHashMap<String, Thread> threads;
    private final GenericServiceListener<RecommenderBuilder> recommenderListener;
    private final GenericServiceListener<RecommenderAccess> recommenderAccess;
    private final Random random;
    private ConcurrentLinkedQueue<Experiment> queue;

    public ExperimentAccess(BundleContext context) {
        this.context = context;
        this.recommenderListener = new GenericServiceListener(context, RecommenderBuilder.class.getName());
        this.recommenderAccess = new GenericServiceListener(context, RecommenderAccess.class.getName());
        this.experiments = new ConcurrentHashMap();
        this.threads = new ConcurrentHashMap();
        this.queue = new ConcurrentLinkedQueue();
        this.onlineExperiments = new ConcurrentHashMap();
        this.random = new Random();
        this.loadExperimentsFromDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExperimentsFromDisk() {
        String userHome = System.getProperty("user.home");
        String separator = System.getProperty("file.separator");
        File recalotFolder = Helper.createOrGetDir((String)(userHome + separator + "recalot"));
        File experimentFolder = Helper.createOrGetDir((String)(recalotFolder.getAbsolutePath() + separator + "experiment-results"));
        for (File file : experimentFolder.listFiles()) {
            try {
                StorageExperiment experiment = this.loadExperiment(file.getAbsolutePath());
                experiment.setId(file.getName());
                ConcurrentHashMap<String, Experiment> concurrentHashMap = this.experiments;
                synchronized (concurrentHashMap) {
                    if (!this.experiments.containsKey(experiment.getId())) {
                        this.experiments.put(experiment.getId(), (Experiment)experiment);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Experiment getExperiment(String id) throws BaseException {
        ConcurrentHashMap<String, Experiment> concurrentHashMap = this.experiments;
        synchronized (concurrentHashMap) {
            if (this.experiments.containsKey(id)) {
                return this.experiments.get(id);
            }
        }
        throw new NotFoundException("Experiment with id %s not found.", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message deleteExperiment(String id) throws BaseException {
        ConcurrentHashMap<String, Experiment> concurrentHashMap = this.experiments;
        synchronized (concurrentHashMap) {
            if (this.experiments.containsKey(id)) {
                this.experiments.remove(id);
                if (this.threads.containsKey(id)) {
                    this.threads.get(id).interrupt();
                    this.threads.remove(id);
                }
                return new Message("Delete successful", String.format("Experiment with id %s successful deleted.", id), Message.Status.INFO);
            }
        }
        throw new NotFoundException("Experiment with id %s not found.", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsExperiment(String experimentId) {
        ConcurrentHashMap<String, Experiment> concurrentHashMap = this.experiments;
        synchronized (concurrentHashMap) {
            return this.experiments.containsKey(experimentId);
        }
    }

    public List<Experiment> getExperiments() throws BaseException {
        return new ArrayList<Experiment>(this.experiments.values());
    }

    public OnlineExperiment createOnlineExperiment(DataSource dataSource, Map<String, String> param) throws BaseException {
        String experimentId = param.get(Helper.Keys.ExperimentId);
        String recommenderIds = param.get(Helper.Keys.RecommenderId);
        OnlineExperiment experiment = new OnlineExperiment();
        experiment.setDataSourceId(dataSource.getSourceId());
        experiment.setId(experimentId);
        Map keyIds = Helper.splitIdKeyConfig((String)recommenderIds);
        for (Object key : keyIds.keySet()) {
            boolean nanOrWrongFormat;
            if (!param.containsKey((String)key + "." + "percentage")) {
                throw new MissingArgumentException("The argument %s is missing. ", (String)key + "." + "percentage");
            }
            try {
                Double number = Double.parseDouble(param.get((String)key + "." + "percentage"));
                nanOrWrongFormat = number.isNaN();
                if (!number.isNaN() && number <= 0.0) {
                    nanOrWrongFormat = false;
                }
            }
            catch (NumberFormatException e) {
                nanOrWrongFormat = true;
            }
            if (!nanOrWrongFormat) continue;
            throw new WrongFormatException("The value %s for the key %s should be a double and greater than 0.", param.get((String)keyIds.get(key) + "." + "percentage"), (String)keyIds.get(key) + "." + "percentage");
        }
        HashMap<String, Double> recommender = new HashMap<String, Double>();
        for (String key : keyIds.keySet()) {
            if (recommenderIds == null) continue;
            Map recommenderKeyIds = Helper.splitIdKeyConfig((String)recommenderIds);
            for (String recKey : recommenderKeyIds.keySet()) {
                param.put((String)recommenderKeyIds.get(recKey) + "." + Helper.Keys.ID, (String)recommenderKeyIds.get(recKey));
                param.put((String)recommenderKeyIds.get(recKey) + "." + Helper.Keys.SourceId, param.get(Helper.Keys.SourceId));
                Double number = Double.parseDouble(param.get(key + "." + "percentage"));
                Recommender rec = ((RecommenderAccess)this.recommenderAccess.getFirstInstance()).createRecommender(dataSource, (String)recommenderKeyIds.get(recKey), param);
                recommender.put(rec.getId(), number);
            }
        }
        Double sum = 0.0;
        for (String recId : recommender.keySet()) {
            sum = sum + (Double)recommender.get(recId);
        }
        for (String recId : recommender.keySet()) {
            recommender.put(recId, (Double)recommender.get(recId) / sum);
        }
        experiment.setRecommender(recommender);
        return experiment;
    }

    public Experiment createExperiment(Recommender[] recommender, DataSource dataSource, DataSplitter splitter, HashMap<String, Metric[]> metrics, ContextProvider context, Map<String, String> param) throws BaseException {
        String id = param.get(Helper.Keys.ExperimentId);
        if (id == null || id.isEmpty()) {
            id = UUID.randomUUID().toString();
        }
        if (this.threads.containsKey(id) || this.experiments.containsKey(id)) {
            throw new AlreadyExistsException("An experiment with the id %s already exists. Please first delete the experiment.", id);
        }
        if (param.get(Helper.Keys.MetricIDs) == null) {
            throw new MissingArgumentException("The argument %s is missing.", Helper.Keys.MetricIDs);
        }
        com.recalot.common.impl.experiment.Experiment experiment = new com.recalot.common.impl.experiment.Experiment(id, dataSource, splitter, recommender, metrics, context, param);
        if (this.threads.size() > 0) {
            this.queue.add((Experiment)experiment);
        } else {
            this.run((Experiment)experiment);
        }
        this.experiments.put(experiment.getId(), (Experiment)experiment);
        return experiment;
    }

    private void runNext() {
        Experiment experiment;
        if (this.queue.size() > 0 && (experiment = this.queue.poll()) != null) {
            this.run(experiment);
        }
    }

    private void run(final Experiment experiment) {
        if (experiment != null) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    experiment.run();
                    ExperimentAccess.this.threads.remove(experiment.getId());
                    ExperimentAccess.this.saveResultToFile(experiment);
                    ExperimentAccess.this.runNext();
                }
            };
            this.threads.put(experiment.getId(), thread);
            thread.start();
        }
    }

    private void saveResultToFile(Experiment experiment) {
        String userHome = System.getProperty("user.home");
        String separator = System.getProperty("file.separator");
        File recalotFolder = Helper.createOrGetDir((String)(userHome + separator + "recalot"));
        File experimentFolder = Helper.createOrGetDir((String)(recalotFolder.getAbsolutePath() + separator + "experiment-results"));
        this.saveExperiment(experimentFolder.getAbsolutePath() + separator + UUID.randomUUID().toString(), experiment);
    }

    private void saveExperiment(String path, Experiment experiment) {
        try {
            FileOutputStream fout = new FileOutputStream(path);
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            oos.writeObject(new StorageExperiment(experiment));
            oos.close();
            fout.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private StorageExperiment loadExperiment(String path) {
        try {
            FileInputStream fis = new FileInputStream(path);
            ObjectInputStream ois = new ObjectInputStream(fis);
            Object obj = ois.readObject();
            ois.close();
            fis.close();
            return (StorageExperiment)obj;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnlineExperiment getOnlineExperiment(String id) throws BaseException {
        ConcurrentHashMap<String, OnlineExperiment> concurrentHashMap = this.onlineExperiments;
        synchronized (concurrentHashMap) {
            if (this.onlineExperiments.containsKey(id)) {
                return this.onlineExperiments.get(id);
            }
        }
        throw new NotFoundException("Online experiment with id %s not found.", id);
    }

    public String getNextRecommenderForOnlineExperiment(String experimentId, Map<String, String> param) throws BaseException {
        OnlineExperiment experiment = this.getOnlineExperiment(experimentId);
        Double r = this.random.nextDouble();
        String recommenderId = null;
        Map bounds = experiment.getRecommenderBounds();
        for (String recId : bounds.keySet()) {
            if (!(r < (Double)bounds.get(recId))) continue;
            recommenderId = recId;
            break;
        }
        if (recommenderId != null && !recommenderId.isEmpty()) {
            return recommenderId;
        }
        throw new NotFoundException("Online experiment with id %s not found.", experimentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message deleteOnlineExperiment(String id) throws BaseException {
        ConcurrentHashMap<String, OnlineExperiment> concurrentHashMap = this.onlineExperiments;
        synchronized (concurrentHashMap) {
            if (this.onlineExperiments.containsKey(id)) {
                this.onlineExperiments.remove(id);
                return new Message("Delete successful", String.format("Online experiment with id %s successful deleted.", id), Message.Status.INFO);
            }
        }
        throw new NotFoundException("Online experiment with id %s not found.", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsOnlineExperiment(String experimentId) {
        ConcurrentHashMap<String, OnlineExperiment> concurrentHashMap = this.onlineExperiments;
        synchronized (concurrentHashMap) {
            return this.onlineExperiments.containsKey(experimentId);
        }
    }

    public List<OnlineExperiment> getOnlineExperiments() throws BaseException {
        return new ArrayList<OnlineExperiment>(this.onlineExperiments.values());
    }

    public String getKey() {
        return "experiment-access";
    }

    public String getDescription() {
        return null;
    }

    public void close() throws IOException {
    }
}

