/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.experiments.splitter;

import com.recalot.common.communication.DataSet;
import com.recalot.common.communication.FillableDataSet;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.Relation;
import com.recalot.common.communication.User;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.data.DataSource;
import com.recalot.common.interfaces.model.experiment.DataSplitter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

@Configurations(value={@Configuration(key="nbFolds", type=ConfigurationItem.ConfigurationItemType.Integer, value="2", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional, description=""), @Configuration(key="seed", type=ConfigurationItem.ConfigurationItemType.Integer, value="1", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional, description="")})
public class RandomNFoldDataSplitter
extends DataSplitter {
    private int seed = 1;

    public DataSet[] split(DataSource source) throws BaseException {
        ArrayList<FillableDataSet> result = new ArrayList<FillableDataSet>();
        for (int i = 0; i < this.getNbFolds(); ++i) {
            result.add(new FillableDataSet());
        }
        Interaction[] allInteractions = source.getInteractions();
        Random r = new Random(this.seed);
        for (Interaction interaction : allInteractions) {
            int next = r.nextInt(this.getNbFolds());
            ((FillableDataSet)result.get(next)).addInteraction(interaction);
        }
        for (Interaction interaction : source.getUsers()) {
            for (FillableDataSet dataSet : result) {
                dataSet.addUser((User)interaction);
            }
        }
        for (Interaction interaction : source.getItems()) {
            for (FillableDataSet dataSet : result) {
                dataSet.addItem((Item)interaction);
            }
        }
        for (Interaction interaction : source.getRelations()) {
            for (FillableDataSet dataSet : result) {
                dataSet.addRelation((Relation)interaction);
            }
        }
        return result.toArray(new DataSet[result.size()]);
    }

    public String getKey() {
        return "random";
    }

    public String getId() {
        return "random";
    }

    public String getDescription() {
        return null;
    }

    public void close() throws IOException {
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public int getSeed() {
        return this.seed;
    }
}

