/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.memory.userKNN;

import com.recalot.common.Helper;
import com.recalot.common.communication.InnerIds;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.communication.User;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.rec.Recommender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

@Configuration(key="maxUsers", type=ConfigurationItem.ConfigurationItemType.Integer, value="1000", description="The maximum amount of examined users.")
public class LiveUserCosKNN
extends Recommender {
    private int maxUsers;

    public void train() throws BaseException {
    }

    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) throws BaseException {
        ArrayList<Integer> emptyVector = new ArrayList<Integer>();
        HashMap<Integer, Integer> itemPosInVector = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> vectorPosPosForItem = new HashMap<Integer, Integer>();
        HashMap consumed = new HashMap();
        int i = 0;
        for (Item item : this.getDataSet().getItems()) {
            emptyVector.add(0);
            vectorPosPosForItem.put(i, InnerIds.getId((String)item.getId()));
            itemPosInVector.put(InnerIds.getId((String)item.getId()), i++);
        }
        HashMap userVectors = new HashMap();
        if (this.maxUsers < this.getDataSet().getUsersCount()) {
            User[] r = new Random();
            while (userVectors.size() < this.maxUsers) {
                int next = r.nextInt(this.getDataSet().getUsersCount() * 10) % this.getDataSet().getUsersCount();
                User user = this.getDataSet().getUsers()[next];
                if (userVectors.containsKey(InnerIds.getId((String)user.getId()))) continue;
                userVectors.put(InnerIds.getId((String)user.getId()), new ArrayList(emptyVector));
            }
            userVectors.put(InnerIds.getId((String)userId), new ArrayList(emptyVector));
        } else {
            for (User user : this.getDataSet().getUsers()) {
                userVectors.put(InnerIds.getId((String)user.getId()), new ArrayList(emptyVector));
            }
        }
        for (User user : this.getDataSet().getInteractions()) {
            int iUserId = InnerIds.getId((String)user.getUserId());
            int iItemId = InnerIds.getId((String)user.getItemId());
            if (!userVectors.containsKey(iUserId) || !itemPosInVector.containsKey(iItemId)) continue;
            int pos = (Integer)itemPosInVector.get(iItemId);
            if (user.getValue() != null && !user.getValue().isEmpty()) {
                int value = Integer.parseInt(user.getValue());
                ((ArrayList)userVectors.get(iUserId)).set(pos, value);
                continue;
            }
            ((ArrayList)userVectors.get(iUserId)).set(pos, 1);
        }
        LinkedHashMap<Integer, Double> similarity = new LinkedHashMap<Integer, Double>();
        int innerUserId = InnerIds.getId((String)userId);
        for (Integer n : userVectors.keySet()) {
            if (innerUserId == n || !userVectors.containsKey(innerUserId) || !userVectors.containsKey(n)) continue;
            List v1 = (List)userVectors.get(innerUserId);
            List v2 = (List)userVectors.get(n);
            similarity.put(n, Helper.computeCosSimilarity((List)v1, (List)v2));
        }
        Map<Integer, Double> itemSim = new LinkedHashMap();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Integer userId2 : similarity.keySet()) {
            if (!userVectors.containsKey(userId2)) continue;
            Integer itemPos = 0;
            while (itemPos < ((ArrayList)userVectors.get(userId2)).size()) {
                Helper.incrementMapValue(linkedHashMap, (Object)itemPos, (Double)((Double)similarity.get(userId2)));
                Helper.incrementMapValue(itemSim, (Object)itemPos, (Double)((Double)similarity.get(userId2) * (double)((Integer)((ArrayList)userVectors.get(userId2)).get(itemPos)).intValue()));
                Integer value = itemPos;
                Integer n = itemPos = Integer.valueOf(itemPos + 1);
            }
        }
        for (Integer itemId : linkedHashMap.keySet()) {
            if (!((Double)linkedHashMap.get(itemId) > 0.0) || !itemSim.containsKey(itemId)) continue;
            itemSim.put(itemId, (Double)itemSim.get(itemId) / (Double)linkedHashMap.get(itemId));
        }
        itemSim = Helper.sortByValueDescending(itemSim);
        ArrayList<RecommendedItem> recommendedItems = new ArrayList<RecommendedItem>();
        for (Integer item : itemSim.keySet()) {
            if ((Integer)((ArrayList)userVectors.get(InnerIds.getId((String)userId))).get(item) != 0) continue;
            int innerId = (Integer)vectorPosPosForItem.get(item);
            String itemId = InnerIds.getId((int)innerId);
            if (!this.getDataSet().hasItem(itemId)) continue;
            recommendedItems.add(new RecommendedItem(this.getDataSet().getItem(itemId), ((Double)itemSim.get(item)).doubleValue()));
        }
        return new RecommendationResult(this.getId(), Helper.applySubList(recommendedItems, param, (int)50));
    }

    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) throws BaseException {
        return 0.0;
    }

    public int getMaxUsers() {
        return this.maxUsers;
    }

    public void setMaxUsers(int maxUsers) {
        this.maxUsers = maxUsers;
    }
}

