/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.data.connections.steam;

import com.recalot.common.communication.InnerIds;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.Relation;
import com.recalot.common.communication.User;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.model.data.connections.base.DataSourceBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;

@Configurations(value={@Configuration(key="dir"), @Configuration(key="interaction", type=ConfigurationItem.ConfigurationItemType.Options, options={"own", "played"})})
public class SteamFileDataSource
extends DataSourceBase {
    private String dir;
    private String interaction;

    public void connect() throws BaseException {
        String source = "flixster";
        File folder = null;
        folder = new File(this.dir);
        File gamesFile = null;
        File friendshipFile = null;
        File usersFile = null;
        File playedFile = null;
        File ownedFile = null;
        block14: for (File file : folder.listFiles()) {
            switch (file.getName().toLowerCase()) {
                case "friendship.csv": {
                    friendshipFile = file;
                    continue block14;
                }
                case "games.csv": {
                    gamesFile = file;
                    continue block14;
                }
                case "own.csv": {
                    ownedFile = file;
                    continue block14;
                }
                case "played.csv": {
                    playedFile = file;
                    continue block14;
                }
                case "users.csv": {
                    usersFile = file;
                }
            }
        }
        if (gamesFile == null || friendshipFile == null || usersFile == null || playedFile == null || ownedFile == null) {
            throw new NotFoundException("Can not find necessary files in '%s'.", this.dir);
        }
        this.setInfo("Read Users");
        this.readUsers(usersFile);
        this.setInfo("Read Games");
        this.readGames(gamesFile);
        this.setInfo("Read Friendship");
        this.readFriendship(friendshipFile);
        this.setInfo("Read Interactions");
        this.readRatingsFile(this.interaction.equals("own") ? ownedFile : playedFile);
        this.setInfo("Done");
    }

    private void readRatingsFile(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            int i = 0;
            while ((line = reader.readLine()) != null) {
                String rating;
                String[] split = line.split(";");
                if (split.length < 2) continue;
                String ratingId = "" + i++;
                String userId = split[0].intern();
                String itemId = split[1].intern();
                String string = rating = split.length > 2 ? split[2].intern() : "1";
                if (!this.users.containsKey(InnerIds.getNextId((String)userId))) {
                    this.users.put(InnerIds.getNextId((String)userId), new User(userId));
                }
                if (!this.items.containsKey(InnerIds.getNextId((String)itemId))) {
                    this.items.put(InnerIds.getNextId((String)itemId), new Item(itemId));
                }
                this.interactions.put(InnerIds.getNextId((String)ratingId), new Interaction(ratingId, userId, itemId, new Date(), "rating".intern(), rating, null));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    private void readFriendship(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            int i = 0;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(";");
                if (split.length != 2) continue;
                String user1 = split[0].intern();
                String user2 = split[1].intern();
                String id = "" + i++;
                this.relations.put(InnerIds.getNextId((String)id), new Relation(id, user1, user2, "friendship".intern()));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    private void readGames(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            boolean i = false;
            while ((line = reader.readLine()) != null) {
                this.items.put(InnerIds.getNextId((String)line), new Item(line));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    private void readUsers(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            boolean i = false;
            while ((line = reader.readLine()) != null) {
                this.users.put(InnerIds.getNextId((String)line), new User(line));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    public void close() throws IOException {
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getInteraction() {
        return this.interaction;
    }

    public void setInteraction(String interaction) {
        this.interaction = interaction;
    }
}

