/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.views.common;

import com.recalot.common.GenericControllerListener;
import com.recalot.common.communication.TemplateResult;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.controller.Controller;
import com.recalot.common.interfaces.controller.RequestAction;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;

public class GenericControllerHandler<T>
implements Closeable {
    private final Map<Long, T> dataAccessController;
    private final GenericControllerListener listener;
    private BundleContext context;

    public GenericControllerHandler(BundleContext context, String className) {
        this.context = context;
        this.dataAccessController = new LinkedHashMap<Long, T>();
        this.listener = new GenericControllerListener(context, className);
        context.addServiceListener((ServiceListener)this.listener);
    }

    public TemplateResult process(RequestAction action, String templateKey) {
        return this.process(action, templateKey, null);
    }

    public TemplateResult process(RequestAction action, String templateKey, Map<String, String> params) {
        Controller controller = this.listener.getFirstInstance();
        if (controller != null) {
            try {
                return controller.process(action, templateKey, params);
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.listener != null) {
            this.context.removeServiceListener((ServiceListener)this.listener);
        }
    }
}

