/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.experiments.metrics.list;

import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.experiment.ListMetric;
import com.recalot.model.experiments.metrics.list.Precision;
import com.recalot.model.experiments.metrics.list.Recall;
import java.util.List;

@Configurations(value={@Configuration(key="topN", type=ConfigurationItem.ConfigurationItemType.Integer, value="10", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional, description=""), @Configuration(key="beta", type=ConfigurationItem.ConfigurationItemType.Double, value="1.0", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional, description="")})
public class FScore
extends ListMetric {
    private double beta;
    private Recall recall = new Recall();
    private Precision precision = new Precision();

    public void setTopN(int topN) {
        this.precision.setTopN(topN);
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    public double getResult() {
        double resultRecall = this.recall.getResult();
        double resultPrecision = this.precision.getResult();
        if (resultRecall == 0.0 && resultPrecision == 0.0) {
            return 0.0;
        }
        return (1.0 + this.beta * this.beta) * (resultPrecision * resultRecall) / (this.beta * this.beta * resultPrecision + resultRecall);
    }

    public void addList(List<String> relevant, List<String> retrieved) {
        this.recall.addList(relevant, retrieved);
        this.precision.addList(relevant, retrieved);
    }

    public String getDescription() {
        return null;
    }
}

