/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.controller.data;

import com.recalot.common.GenericServiceListener;
import com.recalot.common.Helper;
import com.recalot.common.builder.DataSourceBuilder;
import com.recalot.common.communication.DataSet;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.Message;
import com.recalot.common.communication.Relation;
import com.recalot.common.communication.TemplateResult;
import com.recalot.common.communication.User;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.MissingArgumentException;
import com.recalot.common.exceptions.NotReadyException;
import com.recalot.common.interfaces.controller.DataAccessController;
import com.recalot.common.interfaces.controller.RequestAction;
import com.recalot.common.interfaces.model.data.DataAccess;
import com.recalot.common.interfaces.model.data.DataInformation;
import com.recalot.common.interfaces.model.data.DataSource;
import com.recalot.common.interfaces.template.DataTemplate;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;

public class DataAccessController
implements com.recalot.common.interfaces.controller.DataAccessController,
Closeable {
    private final BundleContext context;
    private final GenericServiceListener<DataAccess> dataAccess;
    private final GenericServiceListener<DataTemplate> dataTemplates;

    public DataAccessController(BundleContext context) {
        this.context = context;
        this.dataAccess = new GenericServiceListener(context, DataAccess.class.getName());
        this.dataTemplates = new GenericServiceListener(context, DataTemplate.class.getName());
        this.context.addServiceListener(this.dataAccess);
        this.context.addServiceListener(this.dataTemplates);
    }

    public TemplateResult process(RequestAction action, String templateKey, Map<String, String> param) throws BaseException {
        TemplateResult result = null;
        DataTemplate template = null;
        try {
            template = (DataTemplate)this.dataTemplates.getInstance(templateKey);
            DataAccess access = (DataAccess)this.dataAccess.getFirstInstance();
            switch ((DataAccessController.DataAccessRequestAction)action) {
                case GetData: {
                    result = this.getData(access, template, param);
                    break;
                }
                case GetUser: {
                    result = this.getUser(access, template, param);
                    break;
                }
                case GetUsers: {
                    result = this.getUsers(access, template, param);
                    break;
                }
                case UpdateUser: {
                    result = this.updateUser(access, template, param);
                    break;
                }
                case CreateUser: {
                    result = this.createUser(access, template, param);
                    break;
                }
                case GetItems: {
                    result = this.getItems(access, template, param);
                    break;
                }
                case GetItem: {
                    result = this.getItem(access, template, param);
                    break;
                }
                case UpdateItem: {
                    result = this.updateItem(access, template, param);
                    break;
                }
                case DeleteItem: {
                    result = this.deleteItem(access, template, param);
                    break;
                }
                case CreateItem: {
                    result = this.createItem(access, template, param);
                    break;
                }
                case GetInteractions: {
                    result = this.getInteractions(access, template, param);
                    break;
                }
                case GetInteraction: {
                    result = this.getInteraction(access, template, param);
                    break;
                }
                case AddInteraction: {
                    result = this.addInteraction(access, template, param);
                    break;
                }
                case GetSources: {
                    result = this.getSources(access, template, param);
                    break;
                }
                case CreateSource: {
                    result = this.createSource(access, template, param);
                    break;
                }
                case UpdateSource: {
                    result = this.updateSource(access, template, param);
                    break;
                }
                case GetSource: {
                    result = this.getSource(access, template, param);
                    break;
                }
                case GetDataSourceBuilder: {
                    result = this.getDataSourceBuilder(access, template, param);
                    break;
                }
                case DeleteSource: {
                    result = this.deleteSource(access, template, param);
                    break;
                }
                case GetRelation: {
                    result = this.getRelations(access, template, param);
                    break;
                }
                case GetRelations: {
                    result = this.getRelations(access, template, param);
                    break;
                }
                case CreateRelation: {
                    result = this.createRelation(access, template, param);
                    break;
                }
                case UpdateRelation: {
                    result = this.updateRelation(access, template, param);
                }
            }
        }
        catch (BaseException ex) {
            if (template != null) {
                result = template.transform(ex);
            }
            ex.printStackTrace();
        }
        catch (Exception ex) {
            if (template != null) {
                result = template.transform(new BaseException(ex.getMessage()));
            }
            ex.printStackTrace();
        }
        return result;
    }

    private TemplateResult getDataSourceBuilder(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        String id = param.get(Helper.Keys.SourceId);
        DataSourceBuilder builder = access.getDataSourceBuilder(id);
        if (builder.getConfiguration(Helper.Keys.DataBuilderId) == null) {
            builder.setConfiguration(new ConfigurationItem(Helper.Keys.DataBuilderId, ConfigurationItem.ConfigurationItemType.String, builder.getKey(), ConfigurationItem.ConfigurationItemRequirementType.Hidden));
        }
        return template.transform(builder);
    }

    private TemplateResult getData(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        DataSet data = dataSource.getDataSet();
        return template.transform(data);
    }

    private TemplateResult getRelations(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        String relationId = param.get(Helper.Keys.RelationId);
        String fromId = param.get(Helper.Keys.FromId);
        String toId = param.get(Helper.Keys.ToId);
        if (relationId != null) {
            Relation relation = dataSource.getRelation(relationId);
            return template.transform(relation);
        }
        if (fromId != null || toId != null) {
            Relation[] relations = dataSource.getRelations(fromId, toId);
            return template.transform(relations);
        }
        Relation[] relations = dataSource.getRelations();
        return template.transform(relations);
    }

    private TemplateResult createRelation(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        String fromId = param.get(Helper.Keys.FromId);
        if (fromId == null) {
            throw new MissingArgumentException("The argument %s is missing!", Helper.Keys.FromId);
        }
        String toId = param.get(Helper.Keys.ToId);
        if (toId == null) {
            throw new MissingArgumentException("The argument %s is missing!", Helper.Keys.ToId);
        }
        String type = param.get(Helper.Keys.Type);
        if (type == null) {
            throw new MissingArgumentException("The argument %s is missing!", Helper.Keys.Type);
        }
        Relation relation = dataSource.createRelation(fromId, toId, type, param);
        return template.transform(relation);
    }

    private TemplateResult updateRelation(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        String relationId = param.get(Helper.Keys.RelationId);
        if (relationId == null) {
            throw new MissingArgumentException("The argument %s is missing!", Helper.Keys.RelationId);
        }
        String fromId = param.get(Helper.Keys.FromId);
        if (fromId == null) {
            throw new MissingArgumentException("The argument %s is missing!", Helper.Keys.FromId);
        }
        String toId = param.get(Helper.Keys.ToId);
        if (toId == null) {
            throw new MissingArgumentException("The argument %s is missing!", Helper.Keys.ToId);
        }
        String type = param.get(Helper.Keys.Type);
        if (type == null) {
            throw new MissingArgumentException("The argument %s is missing!", Helper.Keys.Type);
        }
        Relation relation = dataSource.updateRelation(relationId, fromId, toId, type, param);
        return template.transform(relation);
    }

    private TemplateResult getUser(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        String userId = param.get(Helper.Keys.UserId);
        User user = dataSource.getUser(userId);
        return template.transform(user);
    }

    private TemplateResult getUsers(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        Object[] users = dataSource.getUsers();
        users = (User[])Helper.applyPaging((Object[])users, param);
        return template.transform((User[])users);
    }

    private TemplateResult updateUser(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        String userId = param.get(Helper.Keys.UserId);
        User user = dataSource.updateUser(userId, param);
        return template.transform(user);
    }

    private TemplateResult createUser(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        User user = dataSource.createUser(param);
        return template.transform(user);
    }

    private TemplateResult getItems(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        Object[] items = dataSource.getItems();
        items = (Item[])Helper.applyPaging((Object[])items, param);
        return template.transform((Item[])items);
    }

    private TemplateResult getItem(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        Item item = dataSource.getItem(param.get(Helper.Keys.ItemId));
        return template.transform(item);
    }

    private TemplateResult updateItem(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        Item item = dataSource.updateItem(param.get(Helper.Keys.ItemId), param);
        return template.transform(item);
    }

    private TemplateResult deleteItem(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        Message message = dataSource.deleteItem(param.get(Helper.Keys.ItemId));
        return template.transform(message);
    }

    private TemplateResult createItem(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        Item item = dataSource.createItem(param);
        return template.transform(item);
    }

    private TemplateResult addInteraction(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        HashMap<String, String> temp;
        Long t;
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        String itemId = param.get(Helper.Keys.ItemId);
        String userId = param.get(Helper.Keys.UserId);
        String type = param.get(Helper.Keys.Type);
        String value = param.get(Helper.Keys.Value);
        String timestamp = param.get(Helper.Keys.TimeStamp);
        Date date = null;
        if (timestamp != null && !timestamp.isEmpty() && (t = Long.valueOf(Long.parseLong(timestamp))) != null) {
            date = new Date(t);
        }
        if (date == null) {
            date = new Date();
        }
        if (dataSource.tryGetItem(itemId) == null) {
            temp = new HashMap<String, String>();
            temp.put(Helper.Keys.ItemId, itemId);
            dataSource.createItem(temp);
        }
        if (dataSource.tryGetUser(userId) == null) {
            temp = new HashMap();
            temp.put(Helper.Keys.UserId, userId);
            dataSource.createUser(temp);
        }
        Message message = dataSource.addInteraction(itemId, userId, date, type, value, param);
        return template.transform(message);
    }

    private TemplateResult getInteractions(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        String userId = param.get(Helper.Keys.UserId);
        Object[] interaction = userId != null ? dataSource.getInteractions(userId) : dataSource.getInteractions();
        interaction = (Interaction[])Helper.applyPaging((Object[])interaction, param);
        return template.transform((Interaction[])interaction);
    }

    private TemplateResult getInteraction(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource dataSource = this.getDataSource(access, param.get(Helper.Keys.SourceId));
        if (dataSource.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The datasource %s is not yet ready.", dataSource.getId());
        }
        String itemId = param.get(Helper.Keys.ItemId);
        String userId = param.get(Helper.Keys.UserId);
        Object[] interaction = dataSource.getInteractions(itemId, userId);
        interaction = (Interaction[])Helper.applyPaging((Object[])interaction, param);
        return template.transform((Interaction[])interaction);
    }

    private TemplateResult getSources(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        List sources = access.getDataInformations();
        if (param.containsKey(Helper.Keys.State)) {
            DataInformation.DataState state = DataInformation.DataState.valueOf((String)param.get(Helper.Keys.State));
            ArrayList<DataInformation> temp = new ArrayList<DataInformation>();
            for (DataInformation info : sources) {
                if (info.getState() != state) continue;
                temp.add(info);
            }
            return template.transform(temp);
        }
        return template.transform(sources);
    }

    private TemplateResult createSource(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        DataSource source = access.createDataSource(param);
        return template.transform(source);
    }

    private TemplateResult updateSource(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        String id = param.get(Helper.Keys.SourceId);
        Message message = access.updateDataSource(id, param);
        return template.transform(message);
    }

    private TemplateResult getSource(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        String id = param.get(Helper.Keys.SourceId);
        DataSource source = access.getDataSource(id);
        return template.transform(source);
    }

    private TemplateResult deleteSource(DataAccess access, DataTemplate template, Map<String, String> param) throws BaseException {
        String id = param.get(Helper.Keys.SourceId);
        Message message = access.deleteDataSource(id);
        return template.transform(message);
    }

    private DataSource getDataSource(DataAccess access, String sourceId) throws BaseException {
        return access.getDataSource(sourceId);
    }

    @Override
    public void close() throws IOException {
        if (this.dataAccess != null) {
            this.context.removeServiceListener(this.dataAccess);
        }
        if (this.dataTemplates != null) {
            this.context.removeServiceListener(this.dataTemplates);
        }
    }
}

