/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.common;

import com.recalot.common.interfaces.controller.Controller;
import com.recalot.common.log.LogTracker;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class GenericControllerListener<T extends Controller>
implements ServiceListener {
    private final BundleContext context;
    private String className;
    private final Map<Long, T> controller;
    private LogTracker logger;

    public GenericControllerListener(BundleContext context, String className) {
        this.context = context;
        this.className = className;
        this.controller = new LinkedHashMap<Long, T>();
        this.logger = new LogTracker(context);
        this.initialize();
    }

    private void initialize() {
        try {
            ServiceReference[] references = this.context.getServiceReferences(this.className, null);
            if (references != null) {
                for (ServiceReference ref : references) {
                    this.addController((Long)ref.getProperty("service.id"), (Controller)this.context.getService(ref));
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            this.logger.log(1, e.getMessage());
        }
    }

    public void serviceChanged(ServiceEvent event) {
        String[] objectClass = (String[])event.getServiceReference().getProperty("objectClass");
        if (objectClass[0].equals(this.className)) {
            Long serviceId = (Long)event.getServiceReference().getProperty("service.id");
            Controller instance = (Controller)this.context.getService(event.getServiceReference());
            if (event.getType() == 1) {
                this.addController(serviceId, instance);
            } else if (event.getType() == 4) {
                this.removeController(serviceId);
            } else if (event.getType() == 2) {
                this.updateController(serviceId, instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getFirstInstance() {
        Map<Long, T> map = this.controller;
        synchronized (map) {
            if (this.controller.values().size() > 0) {
                return (T)((Controller)this.controller.values().toArray()[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateController(Long id, T instance) {
        Map<Long, T> map = this.controller;
        synchronized (map) {
            this.controller.put(id, instance);
            this.logger.log(3, "Update " + this.className + " controller with id" + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeController(Long id) {
        Map<Long, T> map = this.controller;
        synchronized (map) {
            if (!this.controller.containsKey(id)) {
                this.controller.remove(id);
            }
            this.logger.log(3, "Remove " + this.className + " controller with id" + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addController(Long id, T instance) {
        Map<Long, T> map = this.controller;
        synchronized (map) {
            if (!this.controller.containsKey(id)) {
                this.controller.put(id, instance);
            }
            this.logger.log(3, "Add " + this.className + " controller with id" + id);
        }
    }
}

