/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.librec;

import com.recalot.common.builder.Initiator;
import com.recalot.common.builder.RecommenderBuilder;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.context.Context;
import com.recalot.common.exceptions.BaseException;
import com.recalot.model.rec.librec.GenericLibRecRecommender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator,
Initiator {
    private List<RecommenderBuilder> recommenders;
    private List<Context> contexts;

    public void start(BundleContext context) {
        this.registerRecommenders(context);
        this.registerContext(context);
    }

    private void registerContext(BundleContext context) {
        this.contexts = new ArrayList<Context>();
    }

    private void registerRecommenders(BundleContext context) {
        this.recommenders = new ArrayList<RecommenderBuilder>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("librec-ConstantGuess", "librec.baseline.ConstantGuess");
        map.put("librec-GlobalAverage", "librec.baseline.GlobalAverage");
        map.put("librec-ItemAverage", "librec.baseline.ItemAverage");
        map.put("librec-ItemCluster", "librec.baseline.ItemCluster");
        map.put("librec-MostPopular", "librec.baseline.MostPopular");
        map.put("librec-RandomGuess", "librec.baseline.RandomGuess");
        map.put("librec-UserAverage", "librec.baseline.UserAverage");
        map.put("librec-UserCluster", "librec.baseline.UserCluster");
        map.put("librec-AR", "librec.ext.AR");
        map.put("librec-Hybrid", "librec.ext.Hybrid");
        map.put("librec-NMF", "librec.ext.NMF");
        map.put("librec-PD", "librec.ext.PD");
        map.put("librec-PRankD", "librec.ext.PRankD");
        map.put("librec-SlopeOne", "librec.ext.SlopeOne");
        map.put("librec-AoBPR", "librec.ranking.AoBPR");
        map.put("librec-BHfree", "librec.ranking.BHfree");
        map.put("librec-BPR", "librec.ranking.BPR");
        map.put("librec-BUCM", "librec.ranking.BUCM");
        map.put("librec-CLiMF", "librec.ranking.CLiMF");
        map.put("librec-FISMauc", "librec.ranking.FISMauc");
        map.put("librec-FISMrmse", "librec.ranking.FISMrmse");
        map.put("librec-GBPR", "librec.ranking.GBPR");
        map.put("librec-ItemBigram", "librec.ranking.ItemBigram");
        map.put("librec-LDA", "librec.ranking.LDA");
        map.put("librec-LRMF", "librec.ranking.LRMF");
        map.put("librec-RankALS", "librec.ranking.RankALS");
        map.put("librec-RankSGD", "librec.ranking.RankSGD");
        map.put("librec-SBPR", "librec.ranking.SBPR");
        map.put("librec-SLIM", "librec.ranking.SLIM");
        map.put("librec-WBPR", "librec.ranking.WBPR");
        map.put("librec-WRMF", "librec.ranking.WRMF");
        map.put("librec-BPMF", "librec.rating.BPMF");
        map.put("librec-BiasedMF", "librec.rating.BiasedMF");
        map.put("librec-CPTF", "librec.rating.CPTF");
        map.put("librec-GPLSA", "librec.rating.GPLSA");
        map.put("librec-ItemKNN", "librec.rating.ItemKNN");
        map.put("librec-LDCC", "librec.rating.LDCC");
        map.put("librec-PMF", "librec.rating.PMF");
        map.put("librec-RSTE", "librec.rating.RSTE");
        map.put("librec-RfRec", "librec.rating.RfRec");
        map.put("librec-SVDPlusPlus", "librec.rating.SVDPlusPlus");
        map.put("librec-SoRec", "librec.rating.SoRec");
        map.put("librec-SoReg", "librec.rating.SoReg");
        map.put("librec-SocialMF", "librec.rating.SocialMF");
        map.put("librec-TimeSVD", "librec.rating.TimeSVD");
        map.put("librec-TrustMF", "librec.rating.TrustMF");
        map.put("librec-TrustSVD", "librec.rating.TrustSVD");
        map.put("librec-URP", "librec.rating.URP");
        map.put("librec-UserKNN", "librec.rating.UserKNN");
        for (String key : map.keySet()) {
            try {
                ConfigurationItem[] items;
                RecommenderBuilder builder = new RecommenderBuilder((Initiator)this, GenericLibRecRecommender.class.getName(), key, "");
                builder.setConfiguration(new ConfigurationItem("className", ConfigurationItem.ConfigurationItemType.String, (String)map.get(key), ConfigurationItem.ConfigurationItemRequirementType.Hidden, ""));
                for (ConfigurationItem item : items = GenericLibRecRecommender.getConfigurationItems((String)map.get(key))) {
                    builder.setConfiguration(item);
                }
                this.recommenders.add(builder);
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        for (RecommenderBuilder c : this.recommenders) {
            context.registerService(RecommenderBuilder.class.getName(), (Object)c, null);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.recommenders != null) {
            for (RecommenderBuilder recommenderBuilder : this.recommenders) {
                recommenderBuilder.close();
            }
            this.recommenders = null;
        }
        if (this.contexts != null) {
            for (Context context2 : this.contexts) {
                context2.close();
            }
            this.contexts = null;
        }
    }

    public Object createInstance(String className) {
        try {
            Class<?> c = Class.forName(className);
            return c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

