/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.librec;

import com.recalot.common.Helper;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.model.rec.librec.DataDAO;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import librec.intf.Recommender;

public class GenericLibRecRecommender
extends com.recalot.common.interfaces.model.rec.Recommender {
    private Recommender recommender;
    private DataDAO dataDao;
    private String className;
    private ArrayList<ConfigurationItem> config = new ArrayList();

    public void train() throws BaseException {
        this.dataDao = new DataDAO();
        try {
            this.dataDao.setDataSet(this.getDataSet());
            this.recommender = (Recommender)Class.forName(this.className).newInstance();
            this.applyConfiguration();
            this.recommender.setDao(this.dataDao);
            this.recommender.initModel();
            this.recommender.buildModel();
            this.recommender.postModel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ConfigurationItem[] getConfigurationItems(String className) {
        HashMap<String, ConfigurationItem> items = new HashMap<String, ConfigurationItem>();
        try {
            for (Class<?> recommender = Class.forName(className); recommender != null; recommender = recommender.getSuperclass()) {
                Configuration[] annotations;
                Configuration config;
                if (recommender.isAnnotationPresent(Configuration.class) && (config = recommender.getAnnotation(Configuration.class)) != null && !items.containsKey(config.key())) {
                    items.put(config.key(), new ConfigurationItem(config.key(), config.type(), config.value(), config.requirement(), config.description(), new ArrayList<String>(Arrays.asList(config.options()))));
                }
                if (!recommender.isAnnotationPresent(Configurations.class)) continue;
                for (Configuration t : annotations = recommender.getAnnotation(Configurations.class).value()) {
                    if (items.containsKey(t.key())) continue;
                    items.put(t.key(), new ConfigurationItem(t.key(), t.type(), t.value(), t.requirement(), t.description(), new ArrayList<String>(Arrays.asList(t.options()))));
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
        return items.values().toArray(new ConfigurationItem[items.size()]);
    }

    public void setConfigurationValue(ConfigurationItem item) {
        this.config.add(item);
    }

    public void applyConfiguration() {
        for (ConfigurationItem item : this.config) {
            try {
                switch (item.getType()) {
                    case Integer: {
                        Field f = GenericLibRecRecommender.getField(this.recommender.getClass(), item.getKey(), Integer.class);
                        if (f == null) {
                            f = GenericLibRecRecommender.getField(this.recommender.getClass(), item.getKey(), Integer.TYPE);
                        }
                        if (f == null) break;
                        f.set(this.recommender, Integer.parseInt(item.getValue()));
                        break;
                    }
                    case Double: {
                        Field f = GenericLibRecRecommender.getField(this.recommender.getClass(), item.getKey(), Double.class);
                        if (f == null) {
                            f = GenericLibRecRecommender.getField(this.recommender.getClass(), item.getKey(), Double.TYPE);
                        }
                        if (f == null) break;
                        f.set(this.recommender, Double.parseDouble(item.getValue()));
                        break;
                    }
                    case Boolean: {
                        Field f = GenericLibRecRecommender.getField(this.recommender.getClass(), item.getKey(), Boolean.class);
                        if (f == null) {
                            f = GenericLibRecRecommender.getField(this.recommender.getClass(), item.getKey(), Boolean.TYPE);
                        }
                        if (f == null) break;
                        f.set(this.recommender, Boolean.parseBoolean(item.getValue()));
                        break;
                    }
                    case Options: 
                    case String: {
                        Field f = GenericLibRecRecommender.getField(this.recommender.getClass(), item.getKey(), String.class);
                        if (f == null) break;
                        f.set(this.recommender, item.getValue());
                        break;
                    }
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static Field getField(Class c, String fieldName, Class cl) {
        Field f = null;
        Class tempClass = c;
        boolean isParent = false;
        while (tempClass != null && f == null) {
            try {
                isParent = false;
                f = tempClass.getDeclaredField(fieldName);
                if (!f.getType().equals(cl)) {
                    f = null;
                }
                if (f != null) {
                    f.setAccessible(true);
                    if (!f.isAccessible()) {
                        f = null;
                    }
                }
            }
            catch (NoSuchFieldException e) {
                tempClass = tempClass.getSuperclass();
                isParent = true;
            }
            if (f != null || tempClass == null || isParent) continue;
            tempClass = tempClass.getSuperclass();
        }
        return f;
    }

    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) throws BaseException {
        ArrayList<RecommendedItem> items = new ArrayList<RecommendedItem>();
        try {
            List<String> rec = this.recommendItems(userId, true);
            for (String key : rec) {
                items.add(new RecommendedItem(key, 0.0));
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        return new RecommendationResult(this.getId(), items);
    }

    public List<String> recommendItems(String userId, boolean omitVisited) throws BaseException {
        Interaction[] interactions = this.getDataSet().getInteractions(userId);
        List<Interaction> interactionList = Arrays.asList(interactions);
        HashMap<String, Boolean> visited = new HashMap<String, Boolean>();
        if (omitVisited) {
            for (Interaction interaction : interactionList) {
                if (visited.containsKey(interaction.getItemId())) continue;
                visited.put(interaction.getItemId(), true);
            }
        }
        Map<String, Double> predictions = new HashMap();
        for (Item item : this.getDataSet().getItems()) {
            double pred;
            if (visited.containsKey(item.getId()) || Double.isNaN(pred = this.getRank(userId, item.getId()))) continue;
            predictions.put(item.getId(), pred);
        }
        predictions = Helper.sortByValueDescending(predictions);
        return new ArrayList<String>(predictions.keySet());
    }

    private double getRank(String userId, String itemId) {
        try {
            int item = this.dataDao.getItemId(itemId);
            int user = this.dataDao.getUserId(userId);
            return this.recommender.ranking(user, item);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) throws BaseException {
        int item = this.dataDao.getItemId(itemId);
        int user = this.dataDao.getUserId(userId);
        try {
            return this.recommender.predict(user, item, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

