/*
 * Decompiled with CFR 0.152.
 */
package librec.ext;

import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import java.util.HashMap;
import java.util.Map;
import librec.data.DenseVector;
import librec.data.SparseVector;
import librec.data.SymmMatrix;
import librec.data.VectorEntry;
import librec.ranking.RankSGD;
import librec.util.Lists;
import librec.util.Randoms;

@Configurations(value={@Configuration(key="similarityMeasure", type=ConfigurationItem.ConfigurationItemType.Options, options={"cos", "cos-binary", "msd", "cpc", "exjaccard", "pcc"}, value="pcc", description="similarity measure"), @Configuration(key="similarityShrinkage", type=ConfigurationItem.ConfigurationItemType.Integer, description="similarity shrinkage"), @Configuration(key="alpha", type=ConfigurationItem.ConfigurationItemType.Double, description="similarity filter")})
public class PRankD
extends RankSGD {
    private DenseVector s;
    private SymmMatrix itemCorrs;
    public double alpha;
    public String similarityMeasure;
    public int similarityShrinkage;

    public PRankD() {
        this.isRankingPred = true;
    }

    @Override
    public void initModel() throws Exception {
        int j;
        super.initModel();
        HashMap<Integer, Double> itemProbsMap = new HashMap<Integer, Double>();
        double maxUsers = 0.0;
        this.s = new DenseVector(this.numItems);
        for (j = 0; j < this.numItems; ++j) {
            int users = this.trainMatrix.columnSize(j);
            if (maxUsers < (double)users) {
                maxUsers = users;
            }
            this.s.set(j, users);
            double prob = ((double)users + 0.0) / (double)this.numRates;
            if (!(prob > 0.0)) continue;
            itemProbsMap.put(j, prob);
        }
        this.itemProbs = Lists.sortMap(itemProbsMap);
        for (j = 0; j < this.numItems; ++j) {
            this.s.set(j, this.s.get(j) / maxUsers);
        }
        this.itemCorrs = this.buildCorrs(false, this.similarityMeasure, this.similarityShrinkage);
    }

    @Override
    public void buildModel() throws Exception {
        for (int iter = 1; iter <= this.numIters; ++iter) {
            this.loss = 0.0;
            for (int u : this.trainMatrix.rows()) {
                SparseVector Ru = this.trainMatrix.row(u);
                for (VectorEntry ve : Ru) {
                    int i = ve.index();
                    double rui = ve.get();
                    int j = -1;
                    block3: do {
                        double sum = 0.0;
                        double rand = Randoms.random();
                        for (Map.Entry en : this.itemProbs) {
                            int k = (Integer)en.getKey();
                            double prob = (Double)en.getValue();
                            if (!((sum += prob) >= rand)) continue;
                            j = k;
                            continue block3;
                        }
                    } while (Ru.contains(j));
                    double ruj = 0.0;
                    double pui = this.predict(u, i);
                    double puj = this.predict(u, j);
                    double dij = Math.sqrt(1.0 - this.itemCorrs.get(i, j));
                    double sj = this.s.get(j);
                    double e = sj * (pui - puj - dij * (rui - ruj));
                    this.loss += e * e;
                    double ye = this.lRate * e;
                    for (int f = 0; f < this.numFactors; ++f) {
                        double puf = this.P.get(u, f);
                        double qif = this.Q.get(i, f);
                        double qjf = this.Q.get(j, f);
                        this.P.add(u, f, -ye * (qif - qjf));
                        this.Q.add(i, f, -ye * puf);
                        this.Q.add(j, f, ye * puf);
                    }
                }
            }
            this.loss *= 0.5;
            if (this.isConverged(iter)) break;
        }
    }
}

