/*
 * Decompiled with CFR 0.152.
 */
package librec.ext;

import librec.data.DenseMatrix;
import librec.data.SparseVector;
import librec.intf.Recommender;

public class SlopeOne
extends Recommender {
    private DenseMatrix devMatrix;
    private DenseMatrix cardMatrix;

    @Override
    public void initModel() throws Exception {
        this.devMatrix = new DenseMatrix(this.numItems, this.numItems);
        this.cardMatrix = new DenseMatrix(this.numItems, this.numItems);
    }

    @Override
    public void buildModel() throws Exception {
        for (int u = 0; u < this.numUsers; ++u) {
            int[] items;
            SparseVector uv = this.trainMatrix.row(u);
            for (int i : items = uv.getIndex()) {
                double rui = uv.get(i);
                for (int j : items) {
                    if (i == j) continue;
                    double ruj = uv.get(j);
                    this.devMatrix.add(i, j, rui - ruj);
                    this.cardMatrix.add(i, j, 1.0);
                }
            }
        }
        for (int i = 0; i < this.numItems; ++i) {
            for (int j = 0; j < this.numItems; ++j) {
                double card = this.cardMatrix.get(i, j);
                if (!(card > 0.0)) continue;
                double sum = this.devMatrix.get(i, j);
                this.devMatrix.set(i, j, sum / card);
            }
        }
    }

    @Override
    public double predict(int u, int j) {
        SparseVector uv = this.trainMatrix.row(u, j);
        double preds = 0.0;
        double cards = 0.0;
        for (int i : uv.getIndex()) {
            double card = this.cardMatrix.get(j, i);
            if (!(card > 0.0)) continue;
            preds += (this.devMatrix.get(j, i) + uv.get(i)) * card;
            cards += card;
        }
        return cards > 0.0 ? preds / cards : this.globalMean;
    }
}

