/*
 * Decompiled with CFR 0.152.
 */
package librec.intf;

import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import com.recalot.model.rec.librec.DataDAO;
import librec.data.SparseTensor;
import librec.intf.IterativeRecommender;

@Configurations(value={@Configuration(key="reg", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double), @Configuration(key="boldDriver", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Boolean), @Configuration(key="factors", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer), @Configuration(key="iters", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer), @Configuration(key="lRate", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double), @Configuration(key="maxLRate", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double)})
public class TensorRecommender
extends IterativeRecommender {
    public int numDimensions;
    public int userDimension;
    public int itemDimension;
    protected int[] dimensions;
    protected SparseTensor trainTensor;

    @Override
    public void setDao(DataDAO dataDAO) {
        super.setDao(dataDAO);
        try {
            this.dataDAO.readTensor();
            this.trainTensor = this.dataDAO.getRateTensor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.numDimensions = this.trainTensor.numDimensions();
        this.dimensions = this.trainTensor.dimensions();
        this.userDimension = this.trainTensor.getUserDimension();
        this.itemDimension = this.trainTensor.getItemDimension();
    }

    protected double predict(int[] keys, boolean bound) throws Exception {
        double pred = this.predict(keys);
        if (bound) {
            if (pred > this.maxRate) {
                pred = this.maxRate;
            }
            if (pred < this.minRate) {
                pred = this.minRate;
            }
        }
        return pred;
    }

    protected double predict(int[] keys) throws Exception {
        return this.predict(keys[this.userDimension], keys[this.itemDimension]);
    }
}

