/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import com.google.common.collect.HashBasedTable;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.intf.GraphicRecommender;
import librec.util.Gamma;

@Configurations(value={@Configuration(key="initAlpha", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double, value="1"), @Configuration(key="initBeta", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double, value="0.5"), @Configuration(key="initGamma", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double, value="0.5"), @Configuration(key="burnIn", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double, description="burn-in period", value="1400"), @Configuration(key="sampleLag", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer, value="10", description="sample lag (if -1 only one sample taken)"), @Configuration(key="numFactors", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer, value="30"), @Configuration(key="numIters", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer, value="2000")})
public class BUCM
extends GraphicRecommender {
    public double initGamma;
    private DenseVector gamma;
    private int[][][] Nkir;
    private double[][][] PkirSum;
    protected double[][][] Pkir;

    @Override
    public void initModel() throws Exception {
        this.PukSum = new DenseMatrix(this.numUsers, this.numFactors);
        this.PkiSum = new DenseMatrix(this.numFactors, this.numItems);
        this.PkirSum = new double[this.numFactors][this.numItems][this.numLevels];
        this.Nuk = new DenseMatrix(this.numUsers, this.numFactors);
        this.Nu = new DenseVector(this.numUsers);
        this.Nki = new DenseMatrix(this.numFactors, this.numItems);
        this.Nk = new DenseVector(this.numFactors);
        this.Nkir = new int[this.numFactors][this.numItems][this.numLevels];
        this.alpha = new DenseVector(this.numFactors);
        this.alpha.setAll(this.initAlpha);
        this.beta = new DenseVector(this.numItems);
        this.beta.setAll(this.initBeta);
        this.gamma = new DenseVector(this.numLevels);
        this.gamma.setAll(this.initGamma);
        this.z = HashBasedTable.create();
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int i = me.column();
            double rui = me.get();
            int r = ratingScale.indexOf(rui);
            int t = (int)(Math.random() * (double)this.numFactors);
            this.z.put((Object)u, (Object)i, (Object)t);
            this.Nuk.add(u, t, 1.0);
            this.Nu.add(u, 1.0);
            this.Nki.add(t, i, 1.0);
            this.Nk.add(t, 1.0);
            int[] nArray = this.Nkir[t][i];
            int n = r;
            nArray[n] = nArray[n] + 1;
        }
    }

    @Override
    protected void eStep() {
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        double sumGamma = this.gamma.sum();
        for (MatrixEntry me : this.trainMatrix) {
            int k;
            int u = me.row();
            int i = me.column();
            double rui = me.get();
            int r = ratingScale.indexOf(rui);
            int t = (Integer)this.z.get((Object)u, (Object)i);
            this.Nuk.add(u, t, -1.0);
            this.Nu.add(u, -1.0);
            this.Nki.add(t, i, -1.0);
            this.Nk.add(t, -1.0);
            int[] nArray = this.Nkir[t][i];
            int n = r;
            nArray[n] = nArray[n] - 1;
            double[] p = new double[this.numFactors];
            for (k = 0; k < this.numFactors; ++k) {
                double v1 = (this.Nuk.get(u, k) + this.alpha.get(k)) / (this.Nu.get(u) + sumAlpha);
                double v2 = (this.Nki.get(k, i) + this.beta.get(i)) / (this.Nk.get(k) + sumBeta);
                double v3 = ((double)this.Nkir[k][i][r] + this.gamma.get(r)) / (this.Nki.get(k, i) + sumGamma);
                p[k] = v1 * v2 * v3;
            }
            for (k = 1; k < p.length; ++k) {
                int n2 = k;
                p[n2] = p[n2] + p[k - 1];
            }
            double rand = Math.random() * p[this.numFactors - 1];
            for (t = 0; t < p.length && !(rand < p[t]); ++t) {
            }
            this.z.put((Object)u, (Object)i, (Object)t);
            this.Nuk.add(u, t, 1.0);
            this.Nu.add(u, 1.0);
            this.Nki.add(t, i, 1.0);
            this.Nk.add(t, 1.0);
            int[] nArray2 = this.Nkir[t][i];
            int n3 = r;
            nArray2[n3] = nArray2[n3] + 1;
        }
    }

    @Override
    protected void mStep() {
        double denominator;
        double numerator;
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        double sumGamma = this.gamma.sum();
        for (int k = 0; k < this.numFactors; ++k) {
            double ak = this.alpha.get(k);
            numerator = 0.0;
            denominator = 0.0;
            for (int u = 0; u < this.numUsers; ++u) {
                numerator += Gamma.digamma(this.Nuk.get(u, k) + ak) - Gamma.digamma(ak);
                denominator += Gamma.digamma(this.Nu.get(u) + sumAlpha) - Gamma.digamma(sumAlpha);
            }
            if (numerator == 0.0) continue;
            this.alpha.set(k, ak * (numerator / denominator));
        }
        for (int i = 0; i < this.numItems; ++i) {
            double bi = this.beta.get(i);
            numerator = 0.0;
            denominator = 0.0;
            for (int k = 0; k < this.numFactors; ++k) {
                numerator += Gamma.digamma(this.Nki.get(k, i) + bi) - Gamma.digamma(bi);
                denominator += Gamma.digamma(this.Nk.get(k) + sumBeta) - Gamma.digamma(sumBeta);
            }
            if (numerator == 0.0) continue;
            this.beta.set(i, bi * (numerator / denominator));
        }
        for (int r = 0; r < this.numLevels; ++r) {
            double gr = this.gamma.get(r);
            numerator = 0.0;
            denominator = 0.0;
            for (int i = 0; i < this.numItems; ++i) {
                for (int k = 0; k < this.numFactors; ++k) {
                    numerator += Gamma.digamma((double)this.Nkir[k][i][r] + gr) - Gamma.digamma(gr);
                    denominator += Gamma.digamma(this.Nki.get(k, i) + sumGamma) - Gamma.digamma(sumGamma);
                }
            }
            if (numerator == 0.0) continue;
            this.gamma.set(r, gr * (numerator / denominator));
        }
    }

    @Override
    protected boolean isConverged(int iter) throws Exception {
        this.loss = 0.0;
        this.estimateParams();
        int count = 0;
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int i = me.column();
            double rui = me.get();
            int r = ratingScale.indexOf(rui);
            double prob = 0.0;
            for (int k = 0; k < this.numFactors; ++k) {
                prob += this.Puk.get(u, k) * this.Pki.get(k, i) * this.Pkir[k][i][r];
            }
            this.loss += -Math.log(prob);
            ++count;
        }
        this.loss /= (double)count;
        float delta = (float)(this.loss - this.lastLoss);
        if (this.numStats > 1 && delta > 0.0f) {
            return true;
        }
        this.lastLoss = this.loss;
        return false;
    }

    @Override
    protected void readoutParams() {
        int i;
        int k;
        double val = 0.0;
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        double sumGamma = this.gamma.sum();
        for (int u = 0; u < this.numUsers; ++u) {
            for (int k2 = 0; k2 < this.numFactors; ++k2) {
                val = (this.Nuk.get(u, k2) + this.alpha.get(k2)) / (this.Nu.get(u) + sumAlpha);
                this.PukSum.add(u, k2, val);
            }
        }
        for (k = 0; k < this.numFactors; ++k) {
            for (i = 0; i < this.numItems; ++i) {
                val = (this.Nki.get(k, i) + this.beta.get(i)) / (this.Nk.get(k) + sumBeta);
                this.PkiSum.add(k, i, val);
            }
        }
        for (k = 0; k < this.numFactors; ++k) {
            for (i = 0; i < this.numItems; ++i) {
                int r = 0;
                while (r < this.numLevels) {
                    val = ((double)this.Nkir[k][i][r] + this.gamma.get(r)) / (this.Nki.get(k, i) + sumGamma);
                    double[] dArray = this.PkirSum[k][i];
                    int n = r++;
                    dArray[n] = dArray[n] + val;
                }
            }
        }
        ++this.numStats;
    }

    @Override
    protected void estimateParams() {
        this.Puk = this.PukSum.scale(1.0 / (double)this.numStats);
        this.Pki = this.PkiSum.scale(1.0 / (double)this.numStats);
        this.Pkir = new double[this.numFactors][this.numItems][this.numLevels];
        for (int k = 0; k < this.numFactors; ++k) {
            for (int i = 0; i < this.numItems; ++i) {
                for (int r = 0; r < this.numLevels; ++r) {
                    this.Pkir[k][i][r] = this.PkirSum[k][i][r] / (double)this.numStats;
                }
            }
        }
    }

    @Override
    protected double perplexity(int u, int j, double ruj) throws Exception {
        int r = (int)(ruj / this.minRate) - 1;
        double prob = 0.0;
        for (int k = 0; k < this.numFactors; ++k) {
            prob += this.Puk.get(u, k) * this.Pki.get(k, j) * this.Pkir[k][j][r];
        }
        return -Math.log(prob);
    }

    @Override
    public double predict(int u, int i) throws Exception {
        double pred = 0.0;
        double probs = 0.0;
        for (int r = 0; r < this.numLevels; ++r) {
            double rate = (Double)ratingScale.get(r);
            double prob = 0.0;
            for (int k = 0; k < this.numFactors; ++k) {
                prob += this.Puk.get(u, k) * this.Pki.get(k, i) * this.Pkir[k][i][r];
            }
            pred += prob * rate;
            probs += prob;
        }
        return pred / probs;
    }

    @Override
    public double ranking(int u, int j) throws Exception {
        double rank = 0.0;
        for (int k = 0; k < this.numFactors; ++k) {
            double sum = 0.0;
            for (int r = 0; r < this.numLevels; ++r) {
                double rate = (Double)ratingScale.get(r);
                if (!(rate > this.globalMean)) continue;
                sum += this.Pkir[k][j][r];
            }
            rank += this.Puk.get(u, k) * this.Pki.get(k, j) * sum;
        }
        return rank;
    }
}

