/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.intf.IterativeRecommender;
import librec.util.Lists;
import librec.util.Randoms;

public class WBPR
extends IterativeRecommender {
    private List<Map.Entry<Integer, Double>> sortedItemPops;
    private LoadingCache<Integer, List<Map.Entry<Integer, Double>>> cacheItemProbs;

    public WBPR() {
        this.isRankingPred = true;
        this.initByNorm = false;
    }

    @Override
    public void initModel() throws Exception {
        super.initModel();
        this.itemBias = new DenseVector(this.numItems);
        this.itemBias.init(this.smallValue);
        this.userItemsCache = this.trainMatrix.rowColumnsCache(this.guavaCacheSpec);
        this.sortedItemPops = new ArrayList<Map.Entry<Integer, Double>>();
        for (int i = 0; i < this.numItems; ++i) {
            this.sortedItemPops.add(new AbstractMap.SimpleEntry<Integer, Double>(i, (double)this.trainMatrix.columnSize(i) + 0.0));
        }
        Lists.sortList(this.sortedItemPops, true);
        this.cacheItemProbs = CacheBuilder.from((String)this.guavaCacheSpec).build((CacheLoader)new CacheLoader<Integer, List<Map.Entry<Integer, Double>>>(){

            public List<Map.Entry<Integer, Double>> load(Integer u) throws Exception {
                ArrayList<Map.Entry<Integer, Double>> itemProbs = new ArrayList<Map.Entry<Integer, Double>>();
                List ratedItems = (List)WBPR.this.userItemsCache.get((Object)u);
                double sum = 0.0;
                for (Map.Entry entry : WBPR.this.sortedItemPops) {
                    Integer item = (Integer)entry.getKey();
                    double popularity = (Double)entry.getValue();
                    if (ratedItems.contains(item) || !(popularity > 0.0)) continue;
                    itemProbs.add(new AbstractMap.SimpleEntry(entry));
                    sum += popularity;
                }
                for (Map.Entry entry : itemProbs) {
                    entry.setValue((Double)entry.getValue() / sum);
                }
                return itemProbs;
            }
        });
    }

    @Override
    public void buildModel() throws Exception {
        for (int iter = 1; iter <= this.numIters; ++iter) {
            this.loss = 0.0;
            int smax = this.numUsers * 100;
            for (int s = 0; s < smax; ++s) {
                int u = 0;
                int i = 0;
                int j = 0;
                List ratedItems = null;
                List itemProbs = null;
                while ((ratedItems = (List)this.userItemsCache.get((Object)(u = Randoms.uniform(this.numUsers)))).size() == 0) {
                }
                i = (Integer)Randoms.random(ratedItems);
                itemProbs = (List)this.cacheItemProbs.get((Object)u);
                double rand = Randoms.random();
                double sum = 0.0;
                for (Map.Entry itemProb : itemProbs) {
                    if (!((sum += ((Double)itemProb.getValue()).doubleValue()) >= rand)) continue;
                    j = (Integer)itemProb.getKey();
                    break;
                }
                double xui = this.predict(u, i);
                double xuj = this.predict(u, j);
                double xuij = xui - xuj;
                double vals = -Math.log(this.g(xuij));
                this.loss += vals;
                double cmg = this.g(-xuij);
                double bi = this.itemBias.get(i);
                double bj = this.itemBias.get(j);
                this.itemBias.add(i, this.lRate * (cmg - this.regB * bi));
                this.itemBias.add(j, this.lRate * (-cmg - this.regB * bj));
                this.loss += this.regB * (bi * bi + bj * bj);
                for (int f = 0; f < this.numFactors; ++f) {
                    double puf = this.P.get(u, f);
                    double qif = this.Q.get(i, f);
                    double qjf = this.Q.get(j, f);
                    this.P.add(u, f, this.lRate * (cmg * (qif - qjf) - this.regU * puf));
                    this.Q.add(i, f, this.lRate * (cmg * puf - this.regI * qif));
                    this.Q.add(j, f, this.lRate * (cmg * -puf - this.regI * qjf));
                    this.loss += this.regU * puf * puf + this.regI * qif * qif + this.regI * qjf * qjf;
                }
            }
            if (this.isConverged(iter)) break;
        }
    }

    @Override
    public double predict(int u, int j) throws Exception {
        return this.itemBias.get(j) + DenseMatrix.rowMult(this.P, u, this.Q, j);
    }
}

