/*
 * Decompiled with CFR 0.152.
 */
package librec.rating;

import librec.data.MatrixEntry;
import librec.intf.IterativeRecommender;

public class PMF
extends IterativeRecommender {
    @Override
    public void buildModel() throws Exception {
        for (int iter = 1; iter <= this.numIters; ++iter) {
            this.loss = 0.0;
            for (MatrixEntry me : this.trainMatrix) {
                int u = me.row();
                int j = me.column();
                double ruj = me.get();
                double puj = this.predict(u, j, false);
                double euj = ruj - puj;
                this.loss += euj * euj;
                for (int f = 0; f < this.numFactors; ++f) {
                    double puf = this.P.get(u, f);
                    double qjf = this.Q.get(j, f);
                    this.P.add(u, f, this.lRate * (euj * qjf - this.regU * puf));
                    this.Q.add(j, f, this.lRate * (euj * puf - this.regI * qjf));
                    this.loss += this.regU * puf * puf + this.regI * qjf * qjf;
                }
            }
            this.loss *= 0.5;
            if (this.isConverged(iter)) break;
        }
    }
}

