/*
 * Decompiled with CFR 0.152.
 */
package librec.rating;

import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.intf.IterativeRecommender;

public class RfRec
extends IterativeRecommender {
    private DenseVector userAverages;
    private DenseVector itemAverages;
    private DenseMatrix userRatingFrequencies;
    private DenseMatrix itemRatingFrequencies;
    private DenseVector userWeights;
    private DenseVector itemWeights;

    @Override
    public void initModel() throws Exception {
        this.userAverages = new DenseVector(this.numUsers);
        this.itemAverages = new DenseVector(this.numItems);
        this.userWeights = new DenseVector(this.numUsers);
        this.itemWeights = new DenseVector(this.numItems);
        for (int u = 0; u < this.numUsers; ++u) {
            this.userAverages.set(u, this.trainMatrix.row(u).mean());
            this.userWeights.set(u, 0.6 + Math.random() * 0.01);
        }
        for (int j = 0; j < this.numItems; ++j) {
            this.itemAverages.set(j, this.trainMatrix.column(j).mean());
            this.itemWeights.set(j, 0.4 + Math.random() * 0.01);
        }
        this.userRatingFrequencies = new DenseMatrix(this.numUsers, ratingScale.size());
        this.itemRatingFrequencies = new DenseMatrix(this.numItems, ratingScale.size());
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int j = me.column();
            int ruj = (int)me.get();
            this.userRatingFrequencies.add(u, ruj - 1, 1.0);
            this.itemRatingFrequencies.add(j, ruj - 1, 1.0);
        }
        this.userWeights = new DenseVector(this.numUsers);
        this.itemWeights = new DenseVector(this.numItems);
    }

    @Override
    public void buildModel() throws Exception {
        for (int i = 1; i <= this.numIters; ++i) {
            this.loss = 0.0;
            for (MatrixEntry me : this.trainMatrix) {
                int u = me.row();
                int j = me.column();
                double ruj = me.get();
                double pred = this.predict(u, j);
                double euj = ruj - pred;
                this.loss += euj * euj;
                double userWeight = this.userWeights.get(u) + this.lRate * (euj - this.regU * this.userWeights.get(u));
                this.userWeights.set(u, userWeight);
                double itemWeight = this.itemWeights.get(j) + this.lRate * (euj - this.regI * this.itemWeights.get(j));
                this.itemWeights.set(j, itemWeight);
                this.loss += this.regU * this.userWeights.get(u) * this.userWeights.get(u) + this.regI * this.itemWeights.get(j) * this.itemWeights.get(j);
            }
            this.loss *= 0.5;
            if (this.isConverged(i)) break;
        }
    }

    private int isAvgRating(double avg, int rating) {
        return Math.round(avg) == (long)rating ? 1 : 0;
    }

    @Override
    public double predict(int u, int j) {
        double estimate = this.globalMean;
        float enumeratorUser = 0.0f;
        float denominatorUser = 0.0f;
        float enumeratorItem = 0.0f;
        float denominatorItem = 0.0f;
        if (this.userRatingFrequencies.row(u).sum() > 0.0 && this.itemRatingFrequencies.row(j).sum() > 0.0 && this.userAverages.get(u) > 0.0 && this.itemAverages.get(j) > 0.0) {
            for (int r = 0; r < ratingScale.size(); ++r) {
                int ratingValue = (int)Math.round((Double)ratingScale.get(r));
                int tmpUser = 0;
                double frequencyInt = this.userRatingFrequencies.get(u, ratingValue - 1);
                int frequency = (int)frequencyInt;
                tmpUser = frequency + 1 + this.isAvgRating(this.userAverages.get(u), ratingValue);
                enumeratorUser += (float)(tmpUser * ratingValue);
                denominatorUser += (float)tmpUser;
                int tmpItem = 0;
                frequency = 0;
                frequencyInt = this.itemRatingFrequencies.get(j, ratingValue - 1);
                frequency = (int)frequencyInt;
                tmpItem = frequency + 1 + this.isAvgRating(this.itemAverages.get(j), ratingValue);
                enumeratorItem += (float)(tmpItem * ratingValue);
                denominatorItem += (float)tmpItem;
            }
            double w_u = this.userWeights.get(u);
            double w_i = this.itemWeights.get(j);
            float pred_ui_user = enumeratorUser / denominatorUser;
            float pred_ui_item = enumeratorItem / denominatorItem;
            estimate = (float)w_u * pred_ui_user + (float)w_i * pred_ui_item;
        } else {
            if (this.userRatingFrequencies.row(u).sum() == 0.0 || this.userAverages.get(u) == 0.0) {
                double iavg = this.itemAverages.get(j);
                if (iavg != 0.0) {
                    return iavg;
                }
                return this.globalMean;
            }
            if (this.itemRatingFrequencies.row(j).sum() == 0.0 || this.itemAverages.get(j) == 0.0) {
                double uavg = this.userAverages.get(u);
                if (uavg != 0.0) {
                    return uavg;
                }
                return this.globalMean;
            }
        }
        return estimate;
    }
}

