/*
 * Decompiled with CFR 0.152.
 */
package librec.rating;

import java.util.Iterator;
import java.util.List;
import librec.data.DenseMatrix;
import librec.data.MatrixEntry;
import librec.rating.BiasedMF;

public class SVDPlusPlus
extends BiasedMF {
    protected DenseMatrix Y;

    @Override
    public void initModel() throws Exception {
        super.initModel();
        this.Y = new DenseMatrix(this.numItems, this.numFactors);
        this.Y.init(this.initMean, this.initStd);
        this.userItemsCache = this.trainMatrix.rowColumnsCache(this.guavaCacheSpec);
    }

    @Override
    public void buildModel() throws Exception {
        for (int iter = 1; iter <= this.numIters; ++iter) {
            this.loss = 0.0;
            for (MatrixEntry me : this.trainMatrix) {
                int f;
                int u = me.row();
                int j = me.column();
                double ruj = me.get();
                double pred = this.predict(u, j);
                double euj = ruj - pred;
                this.loss += euj * euj;
                List items = (List)this.userItemsCache.get((Object)u);
                double w = Math.sqrt(items.size());
                double bu = this.userBias.get(u);
                double sgd = euj - this.regB * bu;
                this.userBias.add(u, this.lRate * sgd);
                this.loss += this.regB * bu * bu;
                double bj = this.itemBias.get(j);
                sgd = euj - this.regB * bj;
                this.itemBias.add(j, this.lRate * sgd);
                this.loss += this.regB * bj * bj;
                double[] sum_ys = new double[this.numFactors];
                for (f = 0; f < this.numFactors; ++f) {
                    double sum_f = 0.0;
                    Iterator iterator = items.iterator();
                    while (iterator.hasNext()) {
                        int k = (Integer)iterator.next();
                        sum_f += this.Y.get(k, f);
                    }
                    sum_ys[f] = w > 0.0 ? sum_f / w : sum_f;
                }
                for (f = 0; f < this.numFactors; ++f) {
                    double puf = this.P.get(u, f);
                    double qjf = this.Q.get(j, f);
                    double sgd_u = euj * qjf - this.regU * puf;
                    double sgd_j = euj * (puf + sum_ys[f]) - this.regI * qjf;
                    this.P.add(u, f, this.lRate * sgd_u);
                    this.Q.add(j, f, this.lRate * sgd_j);
                    this.loss += this.regU * puf * puf + this.regI * qjf * qjf;
                    Iterator iterator = items.iterator();
                    while (iterator.hasNext()) {
                        int k = (Integer)iterator.next();
                        double ykf = this.Y.get(k, f);
                        double delta_y = euj * qjf / w - this.regU * ykf;
                        this.Y.add(k, f, this.lRate * delta_y);
                        this.loss += this.regU * ykf * ykf;
                    }
                }
            }
            this.loss *= 0.5;
            if (this.isConverged(iter)) break;
        }
    }

    @Override
    public double predict(int u, int j) throws Exception {
        double pred = this.globalMean + this.userBias.get(u) + this.itemBias.get(j) + DenseMatrix.rowMult(this.P, u, this.Q, j);
        List items = (List)this.userItemsCache.get((Object)u);
        double w = Math.sqrt(items.size());
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            pred += DenseMatrix.rowMult(this.Y, k, this.Q, j) / w;
        }
        return pred;
    }
}

