$("document").ready(function() {
	var url = "analytics.php";
	
	$.getJSON(url, {id:  Math.random()}, function(datasets) {
		if (datasets) {
			// hard-code color indices to prevent them from shifting as
			// countries are turned on/off
			var i = 0;
			$.each(datasets, function(key, val) {
				val.color = i;
				++i;
			});
			
			// insert checkboxes 
			var choiceContainer = $("#choices");
			$.each(datasets, function(key, val) {
				choiceContainer.append('<br/><input type="checkbox" name="' + key +
									   '" checked="checked" id="id' + key + '">' +
									   '<label for="id' + key + '">'
										+ val.label + '</label>');
			});
			choiceContainer.find("input").click(updateGraph);
			
			plotAccordingToChoices(datasets);
			
			$("#choices").show();
		}
		
	});
});

function updateGraph() {
	var url = "analytics.php";

	$.getJSON(url, {id:  Math.random()}, function(datasets) {
		if (datasets) {
			var i = 0;
			$.each(datasets, function(key, val) {
				val.color = i;
				++i;
			});		
		
			plotAccordingToChoices(datasets);
		}
	});
}

function plotAccordingToChoices(datasets) {
	var data = [];
	
	var choiceContainer = $("#choices");

	choiceContainer.find("input:checked").each(function () {
		var key = $(this).attr("name");
		if (key && datasets[key]) {
			data.push(datasets[key]);
		}
	});

	var options = {
            xaxis: {
                mode: "time"
            }
        };
	
	if (data.length > 0) {
		var plotarea = $("#placeholder");
		plotarea.css("height", "250px");
		plotarea.css("width", "500px");
		$.plot( plotarea , data, options );
	}
}