<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:dp="http://www.datapower.com/extensions"
  xmlns:str="http://exslt.org/strings"
  xmlns:regexp="http://exslt.org/regular-expressions"
  extension-element-prefixes="dp"
  exclude-result-prefixes="dp">

  <xsl:template match="/">
    <!-- Retrieve the original Set-Cookie header -->
    <xsl:message dp:priority="debug">Deleting DataPower session cookie</xsl:message>
    <xsl:variable name="set-cookie" select="dp:http-response-header('Set-Cookie')" />
    <xsl:message dp:priority="debug">Current Set-Cookie: <xsl:value-of select="$set-cookie"/> </xsl:message>
    <!-- Remove the LtpaToken2 cookie from the list -->
    <xsl:variable name="cookies" select="str:tokenize($set-cookie,',')"/>
    <xsl:message dp:priority="debug">cookies tokenized: <xsl:copy-of select="$cookies"/> </xsl:message>
    <xsl:variable name="modified-cookie">
	<xsl:for-each select="$cookies[not(regexp:test(text(),'forms.*session.*',''))]">
        <xsl:message dp:priority="debug">adding cookie: <xsl:copy-of select="."/> </xsl:message>
        <xsl:value-of select="."/>
        <!-- Separate with commas, except for the last one -->
        <xsl:if test="not(position()=last())">,</xsl:if>
      </xsl:for-each>
    </xsl:variable>
    <!-- Use regexp:replace to take out the 'Max-Age' parameter -->
    <xsl:message dp:priority="debug">Modifying cookies to remove Max-Age parameters</xsl:message>
    <xsl:variable name="new-cookie" select="regexp:replace($modified-cookie,'Max-Age=\d+;', '','')"/>
    <xsl:message dp:priority="debug">New Set-Cookie: <xsl:value-of select="$new-cookie"/> </xsl:message>
    <!-- Remove the existing Set-Cookie header -->
    <dp:remove-http-response-header name="'Set-Cookie'"/>
    <!-- Set the new Set-Cookie header -->
    <dp:set-http-response-header name="'Set-Cookie'" value="$new-cookie"/>
    <!-- Make sure that the headers can no longer be modified -->
    <dp:freeze-headers/>

  </xsl:template>
</xsl:stylesheet>
