################################################################################
#      This file is part of OpenELEC - http://www.openelec.tv
#      Copyright (C) 2009-2013 Stephan Raue (stephan@openelec.tv)
#
#  OpenELEC is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 2 of the License, or
#  (at your option) any later version.
#
#  OpenELEC is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with OpenELEC.  If not, see <http://www.gnu.org/licenses/>.
################################################################################

import xbmc
import xbmcaddon
import xbmcgui
import os
import sys
import subprocess

__addon__       = xbmcaddon.Addon('script.vdr.front')
__conf_dir__     = __addon__.getSetting("VDR_CONFIG_PATH")
__name_conf__   = 'vdr-front'

######################################################################################################
# dbg_log
def dbg_log(source, text, level=xbmc.LOGDEBUG):
    if __addon__.getSetting("VDR_DEBUG") == "true":
        xbmc.log('## Run VDR Front ## ' + source + ' ## ' + text, level)
    
######################################################################################################
# has_addon
def has_addon(script_name):
    return xbmc.getCondVisibility('System.HasAddon(%s)' % script_name) == 1
    
######################################################################################################
# is_elec
def is_elec():
    return has_addon('service.libreelec.settings') or has_addon('service.openelec.settings')

######################################################################################################
# execute
def execute(command_line, get_result=0):
    try:
        dbg_log('function::execute', 'enter_function', 0)
        dbg_log('function::execute::command', command_line, 0)
        if get_result == 0:
            process = subprocess.Popen(command_line, shell=True, close_fds=True)
            process.wait()
        else:
            result = ''
            process = subprocess.Popen(command_line, shell=True, close_fds=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
            process.wait()
            for line in process.stdout.readlines():
                result = result + line
            return result
        dbg_log('function::execute', 'exit_function', 0)
    except Exception, e:
        dbg_log('function::execute', 'ERROR: (' + repr(e) + ')')

######################################################################################################
# save_conf
def save_conf(options):
    try:
        dbg_log('function::set_service', 'enter_function')

        config = {}
        cfn = '%s/%s.conf' % (__conf_dir__, __name_conf__)

        if os.path.exists(cfn):
            os.remove(cfn)

        with open(cfn, 'w') as cf:
            for option in options:
                cf.write('%s=%s\n' % (option, options[option]))

        dbg_log('function::set_service', 'exit_function')
    except Exception, e:
        dbg_log('function::set_service', 'ERROR: (' + repr(e) + ')')

######################################################################################################
# set_vdr_front_conf
def set_vdr_front_conf():
    try:
        options = {}
        options['VDR_VIDEO_DIR'] = '"%s"' % __addon__.getSetting("VDR_VIDEO_DIR")
        options['VDR_ENABLE_CHARSET_OVERRIDE'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_CHARSET_OVERRIDE")
        options['VDR_CHARSET_OVERRIDE_STR'] = '"%s"' % __addon__.getSetting("VDR_CHARSET_OVERRIDE_STR")
        options['VDR_ENABLE_EXTERNAL_RECCMD'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_EXTERNAL_RECCMD")
        options['VDR_EXTERNAL_RECCMD_PATH'] = '"%s"' % __addon__.getSetting("VDR_EXTERNAL_RECCMD_PATH") 
        options['VDR_DEBUG'] = '"%s"' % __addon__.getSetting("VDR_DEBUG") 
        options['VDR_ENABLE_IPTV'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_IPTV")
        options['VDR_IPTV_NUM_DEVICES'] = '"%s"' % __addon__.getSetting("VDR_IPTV_NUM_DEVICES")
        options['VDR_ENABLE_STREAMDEV_CLIENT'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_STREAMDEV_CLIENT")
        options['VDR_ENABLE_STREAMDEV_SERVER'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_STREAMDEV_SERVER")
        options['VDR_ENABLE_LIVE'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_LIVE")
        options['VDR_LIVE_IP'] = '"%s"' % __addon__.getSetting("VDR_LIVE_IP")
        options['VDR_LIVE_PORT'] = '"%s"' % __addon__.getSetting("VDR_LIVE_PORT")
        options['VDR_ENABLE_EEPG'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_EEPG")
        options['VDR_ENABLE_EPGSEARCH'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_EPGSEARCH")
        options['VDR_ENABLE_XMLTV2VDR'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_XMLTV2VDR")
        options['VDR_ENABLE_DUMMYDEVICE'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_DUMMYDEVICE")
        options['VDR_ENABLE_SATIP'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_SATIP")
        options['VDR_ENABLE_EPGFIXER'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_EPGFIXER")
        options['VDR_ENABLE_RESTFULAPI'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_RESTFULAPI")
        options['VDR_RESTFULAPI_IP'] = '"%s"' % __addon__.getSetting("VDR_RESTFULAPI_IP")
        options['VDR_RESTFULAPI_PORT'] = '"%s"' % __addon__.getSetting("VDR_RESTFULAPI_PORT")
        options['VDR_ENABLE_WIRBELSCAN'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_WIRBELSCAN")
        options['VDR_ENABLE_SOFTCAM'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_SOFTCAM")
        options['VDR_SOFTCAM_OPTION'] = '"%s"' % __addon__.getSetting("VDR_SOFTCAM_OPTION")
        options['VDR_ENABLE_FAVORITES'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_FAVORITES")
        options['VDR_ENABLE_FEMON'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_FEMON")
        options['VDR_ENABLE_SYSTEMINFO'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_SYSTEMINFO")
        options['VDR_ENABLE_SLEEPTIMER'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_SLEEPTIMER")
        options['VDR_ENABLE_FILEBROWSER'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_FILEBROWSER")
        options['VDR_ENABLE_LCDPROC'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_LCDPROC")
        options['VDR_ENABLE_TEXT2SKIN'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_TEXT2SKIN")
        options['VDR_ENABLE_SKINNOPACITY'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_SKINNOPACITY")
        options['VDR_ENABLE_SKINFLAT'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_SKINFLAT")
        options['VDR_ENABLE_SKINFLATPLUS'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_SKINFLATPLUS")
        options['VDR_ENABLE_MENUORG'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_MENUORG")
        options['VDR_ENABLE_TVGUIDE'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_TVGUIDE")
        options['VDR_ENABLE_TVSCRAPER'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_TVSCRAPER")
        options['VDR_ENABLE_SKINDESIGNER'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_SKINDESIGNER")
        options['VDR_ENABLE_WEATHERFORECAST'] = '"%s"' % __addon__.getSetting("VDR_ENABLE_WEATHERFORECAST")
        options['VDR_FRONT'] = '"%s"' % __addon__.getSetting("VDR_FRONT")
        options['VDR_OUTPUT_VIDEO'] = '"%s"' % __addon__.getSetting("VDR_OUTPUT_VIDEO")
        options['VDR_SOUND_SOFT'] = '"%s"' % __addon__.getSetting("VDR_SOUND_SOFT")
        options['VDR_SOUND_XINE'] = '"%s"' % __addon__.getSetting("VDR_SOUND_XINE")
        options['VDR_SOFT_PARAM'] = '"%s"' % __addon__.getSetting("VDR_SOFT_PARAM")
        options['VDR_XINE_PARAM'] = '"%s"' % __addon__.getSetting("VDR_XINE_PARAM")
        save_conf(options)
		
    except IOError as e:
        dbg_log('function::set_vdr_front_conf', 'ERROR: (' + repr(e) + ')')
	
######################################################################################################
# run_vdr_front
def run_vdr_front():
    try:
        if not is_elec():
            set_vdr_front_conf()
            xbmc.executebuiltin('Quit')
        command = __addon__.getSetting("VDR_RUN_COMMAND")
        dbg_log('function::run_vdr_front', ' command [%s]' % command)
        execute(command)
    except IOError as e:
        dbg_log('function::run_vdr_front', 'ERROR: (' + repr(e) + ')')
