<?php

namespace Dotenv\Environment;

use ArrayAccess;

/**
 * This environment variables interface.
 */
interface VariablesInterface extends ArrayAccess
{
    /**
     * Determine if the environment is immutable.
     *
     * @return bool
     */
    public function isImmutable();

    /**
     * Tells whether environment variable has been defined.
     *
     * @param string $name
     *
     * @return bool
     */
    public function has($name);

    /**
     * Get an environment variable.
     *
     * @param string $name
     *
     * @return string|null
     */
    public function get($name);

    /**
     * Set an environment variable.
     *
     * @param string      $name
     * @param string|null $value
     *
     * @return void
     */
    public function set($name, $value = null);

    /**
     * Clear an environment variable.
     *
     * @param string $name
     *
     * @return void
     */
    public function clear($name);
}
