:: ============================================================================
:: Virtual SD card deletion script
:: ============================================================================
@echo off
cls



:: ============================================================================
:: Setup
:: ============================================================================

call settings.bat

set NO_PAUSE=0
if "%1%"=="-p" set NO_PAUSE=1
if "%1%"=="--no-pause" set NO_PAUSE=1

set BATCH_FULL_FILENAME=%0
for %%A in ("%BATCH_FULL_FILENAME%") do (
    set BATCH_PATH=%%~dpA
    set BATCH_FILENAME=%%~nxA
)



:: ============================================================================
:: Check for python
:: ============================================================================

"%PYTHON%" --version > NUL 2> NUL || goto :error_no_python

:: ============================================================================
:: Delete
:: ============================================================================

if not exist "%SD_CARD_PATH%" goto :eof
"%PYTHON%" vsd.py ^
	--path "%SD_CARD_PATH%" ^
	--delete ^
	|| goto :error



:: ============================================================================
:: Success
:: ============================================================================

del "%SHORTCUT_TO_DIRECTORY_FILENAME%" > NUL 2> NUL

goto :eof

:: ============================================================================
:: Execution error
:: ============================================================================
:error
if %NO_PAUSE%==0 (
	color 0c
	pause > NUL 2> NUL
	color
)
goto :eof



:: ============================================================================
:: No python error
:: ============================================================================
:error_no_python
if %NO_PAUSE%==0 color 0c
call settings.bat error_no_python
if %NO_PAUSE%==0 (
	pause > NUL 2> NUL
	color
)
goto :eof

