/*
 * Decompiled with CFR 0.152.
 */
import greenfoot.Actor;
import greenfoot.GreenfootImage;
import greenfoot.GreenfootSound;
import greenfoot.World;
import java.util.ArrayList;

public class MainBubble
extends Bubble {
    private int resistance = 0;
    private int score = 0;
    private ArrayList<GreenfootImage> images = new ArrayList();
    private int sizeBubble = 0;
    private GreenfootSound bubbleSound = new GreenfootSound("bubbleSound.mp3");

    public MainBubble() {
        super(9.8f, 1.0f, "");
        this.addImages();
    }

    public void addImages() {
        for (int numImage = 0; numImage <= 10; ++numImage) {
            this.images.add(new GreenfootImage("bubbleTam" + numImage + ".png"));
        }
    }

    public void setSizeBubble(int newSize) {
        this.sizeBubble = newSize;
    }

    @Override
    public void act() {
        super.act();
        this.moveBubble();
        this.detectRebote();
        this.removeBubbleResistance();
        this.removeBubbleScore();
        this.decreaseSizeBubble();
        if (this.isTouching(Pinchos.class) && this.resistance > 0) {
            --this.resistance;
        }
        if (this.isTouching(BubblePlus.class)) {
            this.bubbleSound.play();
            this.removeTouching(BubblePlus.class);
            this.increaseSizeBubble();
        }
        if (this.getRotation() < 180) {
            super.setDirection("down");
        } else {
            super.setDirection("up");
        }
        this.updateCounters();
    }

    public void updateCounters() {
        World mundo = this.getWorld();
        WorldPlay myWorld = (WorldPlay)mundo;
        myWorld.getCounterScore().setValue(this.score);
        myWorld.getCounterRes().setValue(this.resistance);
        myWorld.getCounterRes().updateBar();
    }

    public void moveBubble() {
        if (this.isTouching(Ventilador.class)) {
            Actor ventNew = new Ventilador();
            ventNew = this.getOneIntersectingObject(Ventilador.class);
            this.setRotation(ventNew.getRotation());
            this.move(1);
        }
    }

    @Override
    public void detectRebote() {
        World world = this.getWorld();
        if (this.getX() == world.getWidth()) {
            if (this.getRotation() < 90 && this.getRotation() > 0) {
                this.setRotation(this.getRotation() + 180);
            } else if (this.getRotation() < 180 && this.getRotation() > 90) {
                this.setRotation(this.getRotation() + this.getRotation());
            }
        }
        if (this.getY() == world.getHeight()) {
            if (this.getRotation() < 359 && this.getRotation() > 275) {
                this.setRotation(this.getRotation() + 180);
            } else if (this.getRotation() < 275 && this.getRotation() > 180) {
                this.setRotation(this.getRotation() + this.getRotation());
            }
        }
    }

    public void removeBubbleResistance() {
        if (this.isTouching(BubbleResistance.class)) {
            this.bubbleSound.play();
            this.removeTouching(BubbleResistance.class);
            if (this.resistance < 10) {
                ++this.resistance;
            }
        }
    }

    public void removeBubbleScore() {
        if (this.isTouching(BubbleScore.class)) {
            this.bubbleSound.play();
            this.removeTouching(BubbleScore.class);
            ++this.score;
        }
    }

    public void increaseSizeBubble() {
        if (this.sizeBubble < 10) {
            ++this.sizeBubble;
            this.setImage(this.images.get(this.sizeBubble));
        }
    }

    @Override
    public String getDirection() {
        return super.getDirection();
    }

    public void decreaseSizeBubble() {
        if (this.isTouching(Pinchos.class) && this.sizeBubble > 0 && this.resistance > 0) {
            Actor newAct = this.getOneIntersectingObject(Pinchos.class);
            Pinchos myAct = (Pinchos)newAct;
            if (myAct.getDirectionPincho() == "up" && super.getDirection() == "down" || myAct.getDirectionPincho() == "down" && super.getDirection() == "up") {
                --this.resistance;
            }
            this.setImage(this.images.get(this.sizeBubble));
        }
    }

    public void decreaseResistance() {
        --this.resistance;
    }
}

