/*
 * Decompiled with CFR 0.152.
 */
import greenfoot.Actor;
import greenfoot.Greenfoot;
import greenfoot.GreenfootImage;

public class WorldPlay
extends ScrollWorld {
    private float gravity;
    private Counter countScore;
    private Counter countRes;
    private MainBubble playerBubble;
    private SimpleTimer timeBubRes;
    private SimpleTimer timeBubScore;
    private SimpleTimer timePincho;
    private SimpleTimer timeBubPlus;
    private Ventilador ventilador;
    private SimpleTimer timeBee;
    private int limitScore;
    private GreenfootImage backgroundWin;
    private GreenfootImage backgroundLose;
    private int totalScore;

    public WorldPlay(float worldGravity, int limitScore) {
        super(1000, 545, 1, 160000, 545);
        this.gravity = worldGravity;
        this.limitScore = limitScore;
        this.countRes = new Counter("Resistencia: ");
        this.countScore = new Counter("Score: ");
        this.countRes.setImage("counterplus.png");
        this.countScore.setImage("counterplus.png");
        this.playerBubble = new MainBubble();
        this.addObject(this.playerBubble, 500, 250);
        this.ventilador = new Ventilador();
        this.backgroundWin = null;
        this.backgroundLose = null;
        this.initializesTimers();
        this.countScore.setRemaining(limitScore);
        this.totalScore = 0;
        this.prepare();
    }

    public void setImagesBackgrounds(String nameImageWin, String nameImageLose) {
        this.backgroundWin = new GreenfootImage(nameImageWin);
        this.backgroundLose = new GreenfootImage(nameImageLose);
    }

    @Override
    public void act() {
        if (this.timeBubRes.millisElapsed() > 3000) {
            this.generateBubbleResistance();
            this.timeBubRes.mark();
        }
        if (this.timeBubScore.millisElapsed() > 3050) {
            this.generateBubbleScore();
            this.timeBubScore.mark();
        }
        if (this.timePincho.millisElapsed() > 5200) {
            this.generateObstaclePinchos();
            this.timePincho.mark();
        }
        if (this.timeBubPlus.millisElapsed() > 3900) {
            this.generateBubblePlus();
            this.timeBubPlus.mark();
        }
    }

    public void setTotalScore(int newScore) {
        this.totalScore += newScore;
    }

    public GreenfootImage getBackgroundWin() {
        return this.backgroundWin;
    }

    public GreenfootImage getBackgroundLose() {
        return this.backgroundLose;
    }

    public void initializesTimers() {
        this.timeBubRes = new SimpleTimer();
        this.timeBubScore = new SimpleTimer();
        this.timePincho = new SimpleTimer();
        this.timeBubPlus = new SimpleTimer();
        this.timeBee = new SimpleTimer();
    }

    public SimpleTimer getTimerBee() {
        return this.timeBee;
    }

    public int getLimitScore() {
        return this.limitScore;
    }

    public float getGravity() {
        return this.gravity;
    }

    public Counter getCounterScore() {
        return this.countScore;
    }

    public Counter getCounterRes() {
        return this.countRes;
    }

    public void generateBubbleResistance() {
        BubbleResistance bubRes = new BubbleResistance();
        this.addObject(bubRes, Greenfoot.getRandomNumber(this.getWidth()), 0);
    }

    public void generateBubbleScore() {
        BubbleScore bubScore = new BubbleScore();
        this.addObject(bubScore, Greenfoot.getRandomNumber(this.getWidth()), 0);
    }

    public void generateObstaclePinchos() {
        Pinchos newPinchos = null;
        newPinchos = Greenfoot.getRandomNumber(2) == 1 ? new Pinchos("up") : new Pinchos("down");
        this.addObject(newPinchos, this.getCameraX() + this.getCameraX(), Greenfoot.getRandomNumber(this.getHeight() + 100));
    }

    public void generateBubblePlus() {
        BubblePlus bubPlus = new BubblePlus();
        this.addObject(bubPlus, Greenfoot.getRandomNumber(this.getWidth()), 0);
    }

    public Ventilador getVentilador() {
        return this.ventilador;
    }

    private void prepare() {
        this.addCameraFollower(new Drone(), 0, 0);
        this.addObject(this.ventilador, 501, 296);
        this.addObject(this.getCounterScore(), 172, 80);
        this.addObject(this.getCounterRes(), 172, 50);
        IconBR iconbr = new IconBR();
        this.addObject(iconbr, 107, 53);
        iconbr.setLocation(104, 48);
        IconBS iconbs = new IconBS();
        this.addObject(iconbs, 112, 87);
        iconbs.setLocation(102, 77);
        iconbs.setLocation(104, 76);
        iconbs.setLocation(104, 77);
        iconbs.setLocation(105, 78);
    }

    public void generateBee() {
        Bee newBee = new Bee();
        this.addObject(newBee, this.getCameraX() + this.getCameraX(), Greenfoot.getRandomNumber(this.getHeight()) + 200);
    }

    public boolean evaluatedScore() {
        boolean estatus = false;
        if (this.countScore.getValue() == this.limitScore) {
            estatus = true;
        }
        return estatus;
    }

    public void removeAllObjects() {
        this.removeObjects(this.getObjects(Actor.class));
    }
}

