/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.input.states;

import greenfoot.event.TriggeredKeyAdapter;
import greenfoot.event.TriggeredKeyListener;
import greenfoot.event.TriggeredMouseAdapter;
import greenfoot.event.TriggeredMouseListener;
import greenfoot.event.TriggeredMouseMotionAdapter;
import greenfoot.event.TriggeredMouseMotionListener;
import greenfoot.gui.input.InputManager;
import greenfoot.gui.input.states.DisabledState;

public abstract class State {
    protected InputManager inputManager;
    private TriggeredKeyListener keyListener;
    private TriggeredMouseListener mouseListener;
    private TriggeredMouseMotionListener mouseMotionListener;

    State(InputManager inputManager, TriggeredKeyListener keyListener, TriggeredMouseListener mouseListener, TriggeredMouseMotionListener mouseMotionListener) {
        this.inputManager = inputManager;
        this.keyListener = keyListener != null ? keyListener : new TriggeredKeyAdapter();
        this.mouseListener = mouseListener != null ? mouseListener : new TriggeredMouseAdapter();
        this.mouseMotionListener = mouseMotionListener != null ? mouseMotionListener : new TriggeredMouseMotionAdapter();
    }

    public void switchToNextState(Event event, Object obj) {
        switch (event) {
            case WORLD_REMOVED: {
                this.inputManager.switchAndActivateState(DisabledState.getInstance(), obj);
            }
        }
    }

    public void activate(Object obj) {
        this.inputManager.activateListeners(this.keyListener, this.mouseListener, this.mouseMotionListener, obj);
    }

    void switchAndActivateState(State state, Object obj) {
        this.inputManager.switchAndActivateState(state, obj);
    }

    public static enum Event {
        CONSTRUCTOR_INVOKED,
        MOUSE_RELEASED,
        SHIFT_PRESSED,
        SHIFT_RELEASED,
        MOUSE_PRESSED,
        SIMULATION_STARTED,
        SIMULATION_STOPPED,
        WORLD_CREATED,
        WORLD_REMOVED,
        OBJECT_MOVED,
        ESC_PRESSED;

    }
}

