/*
 * Decompiled with CFR 0.152.
 */
import greenfoot.Actor;
import greenfoot.GreenfootImage;
import java.awt.Color;
import java.util.ArrayList;

public class Counter
extends Actor {
    private static final Color transparent = new Color(0, 0, 0, 0);
    private GreenfootImage background;
    private int value = 0;
    private int target = 0;
    private String prefix;
    private ArrayList<GreenfootImage> images;
    private ArrayList<GreenfootImage> imagesSave;
    private int remaining;

    public Counter() {
        this(new String());
        this.remaining = 0;
    }

    public Counter(String prefix) {
        this.prefix = prefix;
        this.images = new ArrayList();
        this.imagesSave = new ArrayList();
        this.addImages(this.images);
        this.addImages(this.imagesSave);
    }

    public void setRemaining(int remaining) {
        this.remaining = remaining;
    }

    @Override
    public void setImage(String nameImageFile) {
        this.background = new GreenfootImage(nameImageFile);
        this.updateImage();
    }

    public void addImages(ArrayList<GreenfootImage> listImages) {
        for (int numImage = 0; numImage < 11; ++numImage) {
            listImages.add(new GreenfootImage("counter" + numImage + ".png"));
        }
    }

    @Override
    public void act() {
        if (this.value < this.target) {
            ++this.value;
            this.updateImage();
        } else if (this.value > this.target) {
            --this.value;
            this.updateImage();
        }
    }

    public void updateBar() {
        this.images = this.imagesSave;
        this.background = this.images.get(this.value);
    }

    public void add(int score) {
        this.target += score;
    }

    public int getValue() {
        return this.target;
    }

    public void setValue(int newValue) {
        this.target = newValue;
        this.value = newValue;
        this.updateImage();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.updateImage();
    }

    private void updateImage() {
        GreenfootImage image = new GreenfootImage(this.background);
        GreenfootImage text = new GreenfootImage(this.prefix + this.value + " / " + this.remaining, 22, Color.WHITE, transparent);
        if (this.remaining == 0) {
            text = new GreenfootImage(this.prefix + this.value, 22, Color.WHITE, transparent);
        }
        if (text.getWidth() > image.getWidth() - 20) {
            image.scale(text.getWidth() + 20, image.getHeight());
        }
        image.drawImage(text, (image.getWidth() - text.getWidth()) / 2, (image.getHeight() - text.getHeight()) / 2);
        this.setImage(image);
    }
}

