/*
 * Decompiled with CFR 0.152.
 */
import greenfoot.Actor;

public abstract class ScrollActor
extends Actor {
    private int camX = 0;
    private int camY = 0;
    private int globalX = 0;
    private int globalY = 0;
    private boolean isCameraFollower = false;
    private ScrollWorld world = null;

    public int getGlobalX() {
        if (this.world == null) {
            throw new IllegalStateException("Actor not in world. Either is hasn't been inserted, or it has been deleted.");
        }
        return this.globalX;
    }

    public int getGlobalY() {
        if (this.world == null) {
            throw new IllegalStateException("Actor not in world. Either is hasn't been inserted, or it has been deleted.");
        }
        return this.globalY;
    }

    public int getXFromCamera() {
        if (this.world == null) {
            throw new IllegalStateException("Actor not in world. Either is hasn't been inserted, or it has been deleted.");
        }
        return this.camX;
    }

    public int getYFromCamera() {
        if (this.world == null) {
            throw new IllegalStateException("Actor not in world. Either is hasn't been inserted, or it has been deleted.");
        }
        return this.camY;
    }

    @Override
    public void setLocation(int x, int y) {
        if (this.world == null) {
            return;
        }
        super.setLocation(x, y);
        int halfWorldWidth = this.world.getWidth() / 2;
        int halfWorldHeight = this.world.getHeight() / 2;
        this.camX = x - halfWorldWidth;
        this.camY = y - halfWorldHeight;
        this.globalX = x + (this.world.getCameraX() - halfWorldWidth);
        this.globalY = y + (this.world.getCameraY() - halfWorldHeight);
    }

    public void setLocationFromCamera(int x, int y) {
        this.setLocation(x + this.world.getCameraX(), y + this.world.getCameraY());
    }

    public void setGlobalLocation(int x, int y) {
        int subX = this.world.getCameraX() - this.world.getWidth() / 2;
        int subY = this.world.getCameraY() - this.world.getHeight() / 2;
        this.setLocation(x - subX, y - subY);
    }

    @Override
    public ScrollWorld getWorld() {
        return this.world;
    }

    @Override
    public void move(int distance) {
        if (distance == 0) {
            return;
        }
        double radians = Math.toRadians(this.getRotation());
        double sin = Math.sin(radians);
        double cos = Math.cos(radians);
        int dx = (int)Math.round(cos * (double)distance);
        int dy = (int)Math.round(sin * (double)distance);
        this.setLocation(this.getX() + dx, this.getY() + dy);
    }

    public void turnTowardsGlobalLocation(int x, int y) {
        if (x == this.globalX && y == this.globalY) {
            return;
        }
        double a = Math.atan2(y - this.globalY, x - this.globalX);
        int newRotation = (int)Math.round(Math.toDegrees(a));
        this.setRotation(newRotation);
    }

    public void turnTowardsCameraLocation(int x, int y) {
        if (x == this.camX && y == this.camY) {
            return;
        }
        double a = Math.atan2(y - this.camY, x - this.camX);
        int newRotation = (int)Math.round(Math.toDegrees(a));
        this.setRotation(newRotation);
    }

    public boolean isCameraFollower() {
        if (this.world == null) {
            throw new IllegalStateException("Actor not in world. Either is hasn't been inserted, or it has been deleted.");
        }
        return this.isCameraFollower;
    }

    void setIsCameraFollower(boolean value) {
        this.isCameraFollower = value;
        this.world = (ScrollWorld)super.getWorld();
        if (value) {
            this.setLocation(this.getX(), this.getY());
        }
    }
}

