/*
 * Decompiled with CFR 0.152.
 */
import greenfoot.Actor;
import greenfoot.GreenfootImage;
import greenfoot.World;
import java.util.ArrayList;

public abstract class ScrollWorld
extends World {
    private final int width;
    private final int height;
    private final int cellSize;
    private final ArrayList<ScrollActor> objects;
    private final ArrayList<ScrollActor> camFollowers;
    private final int fullWidth;
    private final int fullHeight;
    private int camX;
    private int camY;
    private int camDir;
    private final GreenfootImage bigBackground;
    private final GreenfootImage back = this.getBackground();
    private int scrollPosX;
    private int scrollPosY;

    public ScrollWorld(int width, int height, int cellSize, int fullWidth, int fullHeight) {
        super(width, height, cellSize, false);
        this.width = this.back.getWidth();
        this.height = this.back.getHeight();
        this.cellSize = cellSize;
        this.fullWidth = fullWidth;
        this.fullHeight = fullHeight;
        if (fullWidth <= 0) {
            throw new IllegalArgumentException("The width of the big space (" + fullWidth + ") can't be smaller then the width of the world (" + width + ")");
        }
        if (fullHeight <= 0) {
            throw new IllegalArgumentException("The height of the big space (" + fullHeight + ") can't be smaller then the height of the world (" + height + ")");
        }
        this.objects = new ArrayList();
        this.camFollowers = new ArrayList();
        this.camX = this.getWidth() / 2;
        this.camY = this.getHeight() / 2;
        this.camDir = 0;
        this.scrollPosX = 0;
        this.scrollPosY = 0;
        this.bigBackground = new GreenfootImage(width + width, height + height);
        this.setNewBackground(this.back);
    }

    public void setNewBackground(GreenfootImage background) {
        this.bigBackground.clear();
        if (background.getWidth() == this.bigBackground.getWidth() && background.getHeight() == this.bigBackground.getHeight()) {
            this.bigBackground.drawImage(background, 0, 0);
            this.back.clear();
            this.back.drawImage(this.bigBackground, this.scrollPosX, this.scrollPosY);
            return;
        }
        this.bigBackground.drawImage(background, 0, 0);
        this.bigBackground.drawImage(background, background.getWidth(), 0);
        this.bigBackground.drawImage(background, 0, background.getHeight());
        this.bigBackground.drawImage(background, background.getWidth(), background.getHeight());
        this.back.clear();
        this.back.drawImage(this.bigBackground, this.scrollPosX, this.scrollPosY);
    }

    public void addCameraFollower(ScrollActor cameraFollower, int x, int y) {
        super.addObject(cameraFollower, this.getWidth() / 2 + x, this.getHeight() / 2 + y);
        this.camFollowers.add(cameraFollower);
        cameraFollower.setIsCameraFollower(true);
    }

    @Override
    public void addObject(Actor object, int x, int y) {
        if (object instanceof ScrollActor) {
            if (x >= this.fullWidth) {
                x = this.fullWidth - 1;
            } else if (x < 0) {
                x = 0;
            }
            if (y >= this.fullHeight) {
                y = this.fullHeight - 1;
            } else if (y < 0) {
                y = 0;
            }
            ScrollActor sa = (ScrollActor)object;
            super.addObject(sa, x - (this.camX - this.getWidth() / 2), y - (this.camY - this.getHeight() / 2));
            this.objects.add(sa);
            sa.setIsCameraFollower(false);
        } else {
            super.addObject(object, x, y);
        }
    }

    @Override
    public void removeObject(Actor object) {
        super.removeObject(object);
        if (object instanceof ScrollActor) {
            ScrollActor a = (ScrollActor)object;
            this.objects.remove(a);
            this.camFollowers.remove(a);
            a.setIsCameraFollower(false);
        }
    }

    public int getCameraX() {
        return this.camX;
    }

    public int getCameraY() {
        return this.camY;
    }

    public int getFullWidth() {
        return this.fullWidth;
    }

    public int getFullHeight() {
        return this.fullHeight;
    }

    public void setCameraLocation(int x, int y) {
        if (this.camX == x && this.camY == y) {
            return;
        }
        if (x > this.fullWidth - this.getWidth() / 2) {
            x = this.fullWidth - this.getWidth() / 2;
        } else if (x < this.getWidth() / 2) {
            x = this.getWidth() / 2;
        }
        if (y > this.fullHeight - this.getHeight() / 2) {
            y = this.fullHeight - this.getHeight() / 2;
        } else if (y < this.getHeight() / 2) {
            y = this.getHeight() / 2;
        }
        int dx = x - this.camX;
        int dy = y - this.camY;
        this.camX = x;
        this.camY = y;
        for (ScrollActor a : this.objects) {
            a.setLocation(a.getX() - dx, a.getY() - dy);
        }
        for (ScrollActor a : this.camFollowers) {
            a.setLocation(a.getX(), a.getY());
        }
        this.moveBackgroundRight(dx * this.cellSize);
        this.moveBackgroundUp(dy * this.cellSize);
    }

    public void setCameraDirection(int degrees) {
        if (degrees >= 360) {
            degrees = degrees < 720 ? (degrees -= 360) : (degrees %= 360);
        } else if (degrees < 0) {
            degrees = degrees >= -360 ? (degrees += 360) : 360 + degrees % 360;
        }
        if (this.camDir == degrees) {
            return;
        }
        this.camDir = degrees;
    }

    public void turnCamera(int amount) {
        this.setCameraDirection(this.camDir + amount);
    }

    public void moveCamera(int amount) {
        if (amount == 0) {
            return;
        }
        double radians = Math.toRadians(this.camDir);
        double dx = Math.cos(radians) * (double)amount;
        double dy = Math.sin(radians) * (double)amount;
        this.setCameraLocation((int)((double)this.camX + dx + 0.5), (int)((double)this.camY + dy + 0.5));
    }

    private void moveBackgroundUp(int amount) {
        if (amount == 0) {
            return;
        }
        int height = this.getHeight();
        this.scrollPosY -= amount;
        while (this.scrollPosY < 0) {
            this.scrollPosY += height;
        }
        this.scrollPosY %= height;
        this.getBackground().drawImage(this.bigBackground, this.scrollPosX - this.getWidth(), this.scrollPosY - height);
    }

    private void moveBackgroundRight(int amount) {
        if (amount == 0) {
            return;
        }
        int width = this.getWidth();
        this.scrollPosX -= amount;
        while (this.scrollPosX < 0) {
            this.scrollPosX += width;
        }
        this.scrollPosX %= width;
        this.getBackground().drawImage(this.bigBackground, this.scrollPosX - width, this.scrollPosY - this.getHeight());
    }
}

