/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision.ibsp;

import greenfoot.Actor;
import greenfoot.collision.ibsp.ActorNode;
import greenfoot.collision.ibsp.Rect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class BSPNode {
    private Map<Actor, ActorNode> actors;
    private BSPNode parent;
    private Rect area;
    private int splitAxis;
    private int splitPos;
    private BSPNode left;
    private BSPNode right;
    private boolean areaRipple;

    public BSPNode(Rect area, int splitAxis, int splitPos) {
        this.area = area;
        this.splitAxis = splitAxis;
        this.splitPos = splitPos;
        this.actors = new HashMap<Actor, ActorNode>();
    }

    public void setChild(int side, BSPNode child) {
        if (side == 0) {
            this.left = child;
            if (child != null) {
                child.parent = this;
            }
        } else {
            this.right = child;
            if (child != null) {
                child.parent = this;
            }
        }
    }

    public void setArea(Rect area) {
        this.area = area;
        this.areaRipple = true;
    }

    public void setSplitAxis(int axis) {
        if (axis != this.splitAxis) {
            this.splitAxis = axis;
            this.areaRipple = true;
        }
    }

    public void setSplitPos(int pos) {
        if (pos != this.splitPos) {
            this.splitPos = pos;
            this.areaRipple = true;
        }
    }

    public int getSplitAxis() {
        return this.splitAxis;
    }

    public int getSplitPos() {
        return this.splitPos;
    }

    public Rect getLeftArea() {
        if (this.splitAxis == 0) {
            return new Rect(this.area.getX(), this.area.getY(), this.splitPos - this.area.getX(), this.area.getHeight());
        }
        return new Rect(this.area.getX(), this.area.getY(), this.area.getWidth(), this.splitPos - this.area.getY());
    }

    public Rect getRightArea() {
        if (this.splitAxis == 0) {
            return new Rect(this.splitPos, this.area.getY(), this.area.getRight() - this.splitPos, this.area.getHeight());
        }
        return new Rect(this.area.getX(), this.splitPos, this.area.getWidth(), this.area.getTop() - this.splitPos);
    }

    public Rect getArea() {
        return this.area;
    }

    private void resizeChildren() {
        if (this.left != null) {
            this.left.setArea(this.getLeftArea());
        }
        if (this.right != null) {
            this.right.setArea(this.getRightArea());
        }
    }

    public BSPNode getLeft() {
        if (this.areaRipple) {
            this.resizeChildren();
            this.areaRipple = false;
        }
        return this.left;
    }

    public BSPNode getRight() {
        if (this.areaRipple) {
            this.resizeChildren();
            this.areaRipple = false;
        }
        return this.right;
    }

    public BSPNode getParent() {
        return this.parent;
    }

    public void setParent(BSPNode parent) {
        this.parent = parent;
    }

    public int getChildSide(BSPNode child) {
        if (this.left == child) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        return "bsp" + this.hashCode();
    }

    public void addActor(Actor actor) {
        this.actors.put(actor, new ActorNode(actor, this));
    }

    public boolean containsActor(Actor actor) {
        ActorNode anode = this.actors.get(actor);
        if (anode != null) {
            anode.mark();
            return true;
        }
        return false;
    }

    public void actorRemoved(Actor actor) {
        this.actors.remove(actor);
    }

    public int numberActors() {
        return this.actors.size();
    }

    public boolean isEmpty() {
        return this.actors.isEmpty();
    }

    public Iterator<Map.Entry<Actor, ActorNode>> getEntriesIterator() {
        return this.actors.entrySet().iterator();
    }

    public Iterator<Actor> getActorsIterator() {
        return this.actors.keySet().iterator();
    }

    public List<Actor> getActorsList() {
        return new ArrayList<Actor>(this.actors.keySet());
    }

    void blankNode() {
        this.actors.clear();
    }

    public void areaChanged() {
        this.areaRipple = true;
    }
}

