//----------------------------------------------------------------------
// Temperature and Humidity Logger 
// Description: Logs temperture from 4 temp and 3 humidity sensors
//            
// Last revision 1st Dec 2010
// Licence: GNU GPL
// By Glyn Hudson 
//----------------------------------------------------------------------

//----------------------------------------------------------------------------------------------------------------------------------
// Librarys 
//----------------------------------------------------------------------------------------------------------------------------------

#include <OneWire.h>              //one wire sensor protocol library (V2.0) from http://www.pjrc.com/teensy/td_libs_OneWire.html 
#include <DallasTemperature.h>    //dallas one wire temperature library (V3.6.0) from http://milesburton.com/index.php/Dallas_Temperature_Control_Library 
#include <Wire.h>                 //serial commmunciation library. Needed for LCD SDA, SCL (Analogu 4 and 5)
#include <LiquidCrystal_I2C.h>    //serial LCD library. DFRobot http://www.dfrobot.com/image/data/DFR0063/Arduino_library.rar info: http://www.dfrobot.com/wiki/index.php?title=I2C/TWI_LCD1602_Module_(SKU:_DFR0063)
#include <SdFat.h>                //SD card file system library GNU GPL V3 (Version 20100818) http://code.google.com/p/sdfatlib/
#include <DS1302.h>               //Real Time clock (RTC) lib (C) Henning Karlsen http://www.henningkarlsen.com/electronics/a_l_ds1302.php


//----------------------------------------------------------------------------------------------------------------------------------
// Connections
//----------------------------------------------------------------------------------------------------------------------------------

//IMPORTANT: for SD card code to work with Nuelectroncis datalogging shield a jumper is needed between digital 10 and 5
//since NUelectroncis uses a difffernet chip select line. 

// Temperature sensor Data wire is plugged into digital pin 15/ analogue pin 1 / socket P5 on Nu electronics sensor shield
int temperature_sensor_bus=15; //DS18B20 bus. Pins 1 and 3 grounded. Pin 2 to sensor bus and pulled up by 4K7 resistor 
int humidity_sensor1=2; //humidity 1 to ADC 2 / Nuelectronics P6
int humidity_sensor2=0; //humidity 2 to ADC 0 / Nuelectronics P4
int humidity_sensor3=3; //humidity 2 to ADC 3 / Nuelectronics P7

int greenLEDpin=2;        //LED file system / SD card syncing activity 

//RTC uses digital pin 3 (SCLK), pin 4 (I/O), pin 5 (CE)
// Init the DS1302 passing conection pin numbers 
DS1302 rtc(6, 4, 3);
//-----------------------------------------------------------------------------------------------------------------------------------


// Setup a oneWire instance to communicate with any OneWire devices (not just Maxim/Dallas temperature ICs)
OneWire oneWire(temperature_sensor_bus);

// Pass our oneWire reference to Dallas Temperature. 
DallasTemperature sensors(&oneWire);

// LCD connected to analogue 4 and 5. Serial SDA and SCL. Nuelectronics shield connector P1
LiquidCrystal_I2C lcd(0x27,16,2);  // set the LCD address to 0x27

//define variables for SD card logging 
int LOG_INTERVAL=1000; // mills between entries
int ECHO_TO_SERIAL=1; // echo data to serial port
int SYNC_INTERVAL=30000; // Sensor reading saved to SD card every min
long syncTime = 0;     // time of last sync()

// The objects to talk to the SD card
Sd2Card card;
SdVolume volume;
SdFile root;
SdFile file;

//--------------------------------------------------------------------------
//Function Decleration 
//--------------------------------------------------------------------------

void lcd_update(float,float,float,float,int,int,int);     //pass variables to be displayed on LCD
float get_temperature(int);                     //pass sensor number (0-2) to get temp from
int get_humidity(int);                          //pass analogue pin humidity sensor is connected to
void sd_card(float,float,float,int,int,int);        //sd card logging code


//--------------------------------------------------------------------------
//SETUP
//--------------------------------------------------------------------------

void setup(void)
{
  // start serial port
  Serial.begin(9600);
  
   //lcd Setup
  lcd.init();
  lcd.backlight();              //turn on LCD backlight
  lcd.clear();                  // start with a blank screen
  
  
  // initialize the SD card
  if (!card.init()) error("card.init");
  
  // initialize a FAT volume
  if (!volume.init(card)) error("volume.init");
  
  // open root directory
  if (!root.openRoot(volume)) error("openRoot");
  
  // create a new file
  char name[] = "LOGGER00.CSV";
  for (uint8_t i = 0; i < 100; i++) {
    name[6] = i/10 + '0';
    name[7] = i%10 + '0';
    if (file.open(root, name, O_CREAT | O_EXCL | O_WRITE)) break;
  }
  if (!file.isOpen()) error ("file.create");


  
  file.writeError = 0;

  // write header
  file.println("Date Time,Temp 1,Temp 2, Temp 3, Temp4, Humidity 1, Humidity 2, Humidity 3");    
if (ECHO_TO_SERIAL) Serial.println("Date Time,Temp 1,Temp 2, Temp 3, Temp4, Humidity 1, Humidity 2, Humidity 3");
  
  pinMode(greenLEDpin, OUTPUT); //set SD card activity LED pin to output mode
  digitalWrite(greenLEDpin,HIGH);


  // attempt to write out the header to the file
  if (file.writeError || !file.sync()) {
    error("write header");
  }

   
   
  // Start up the DallasTemperature senosr library
  sensors.begin();
  
  // Set the clock to run-mode, and disable the write protection
  rtc.halt(false);
  rtc.writeProtect(false);
  
  // Set RTC date and time (if needed!) 
  //rtc.setDOW(MONDAY);        // Set Day-of-Week to FRIDAY
  //rtc.setTime(10, 15, 0);     // Set the time to 12:00:00 (24hr format)
  //rtc.setDate(1, 11, 2010);   // Set the date to August 6th, 2010
  
  //start up procedure 
  lcd.clear(); lcd.setCursor(0,0);
  lcd.print("Bee Monitor V1.0"); lcd.setCursor(0,1); lcd.print(rtc.getDateStr());
  
  
  
  int number_of_devices=sensors.getDeviceCount();                            //get number of temp sensors
  
  delay(2000);
  
  
  lcd.clear(); lcd.setCursor(0,0); lcd.print("Locating Devices..."); lcd.setCursor(0,1); lcd.print("....");
  delay(800); //one second delay
  lcd.clear();
  lcd.setCursor(0,0); lcd.print("Detected "); lcd.print(number_of_devices); 
  lcd.setCursor(0,1); lcd.print( "temp sensors");
  

  delay(1000); 
  
  lcd.clear(); lcd.setCursor(0,0); lcd.print("Logging to: "); lcd.setCursor(0,1); lcd.print(name);
  
  delay(2000);
  
  if (ECHO_TO_SERIAL) {
    Serial.print("Detected "); Serial.print(number_of_devices); 
    Serial.println(" temperature sensors");
    Serial.print("Logging to: "); Serial.println(name);
  }
   
   digitalWrite(greenLEDpin,LOW);

} //end setup

//--------------------------------------------------------------------------
//Loop
//--------------------------------------------------------------------------

void loop(void)
{ 
  
  

  
  // delay for the amount of time we want between readings
  //delay((LOG_INTERVAL -1) - (millis() % LOG_INTERVAL));
   

 if ((millis()-syncTime) > SYNC_INTERVAL){ 
   
     // clear print error
  file.writeError = 0;
  
   // call sensors.requestTemperatures() to issue a global temperature request to all devices on the bus 
  sensors.requestTemperatures();
    
    //get individual sensor temperatures 
    float temp1=get_temperature(0);
    float temp2=get_temperature(1);
    float temp3=get_temperature(2);
    float temp4=get_temperature(3);
  
    //Get Humidity for each sensor  
    int humidity1=get_humidity(humidity_sensor1);
    int humidity2=get_humidity(humidity_sensor2); 
    int humidity3=get_humidity(humidity_sensor3);
  
    
    //update lcd
    lcd_update(temp1,temp2,temp3, temp4, humidity1,humidity2,humidity3);
    
    //log data to SD card
    
   
    
  
      sd_card(temp1,temp2,temp3,temp4,humidity1,humidity2,humidity3);
      syncTime=millis();
  
  
  //if ((temp1==-127) || (humidity1==0) || (humidity2==0)) //light up indicator LED if sensor error
  //digitalWrite(greenLEDpin, HIGH); else digitalWrite(greenLEDpin, LOW);
 } 
  
  

}  //end loop



//SD card error function 
void error(char *str)
{
  boolean flag=false;
  Serial.print("error: "); Serial.println(str);
 
  if (flag==false) {
  lcd.clear(); lcd.setCursor(0,0); lcd.print("error: "); lcd.setCursor(0,1); lcd.print(str);
  flag=true;}
  
  while(1){
    digitalWrite(greenLEDpin, HIGH);
    delay(100);
    digitalWrite(greenLEDpin, LOW);
  }
    
    ;
}


