/*
  RFM12B transmission checker (receiver)
  Displays each message received, and drives the led accordingly
 
*/

#define ON HIGH
#define OFF LOW

const byte ledPin = 5;

/* frequency options are RF12_433MHZ, RF12_868MHZ or RF12_915MHZ
 */
#define freq RF12_868MHZ // Use the freq to match the module you have.

const int TXnodeID = 10;
                                              
const int myNode = 15;
											
const int networkGroup = 210;                  

const int UNO = 1;
                                               // Set to 0 if you're not using the UNO bootloader (i.e using Duemilanove) - All Atmega's shipped from OpenEnergyMonitor come with Arduino Uno bootloader

#include <JeeLib.h>                            // Download JeeLib: http://github.com/jcw/jeelib


typedef struct { byte dumpFlag; } PayloadStruct;    
PayloadStruct payload;


void setup() 
{
  Serial.begin(9600);
  delay(5000);
  Serial.println("transmission test transmitter");
  Serial.print("Node: "); 
  Serial.print(myNode); 
  Serial.print(" Freq: "); 
  if (freq == RF12_433MHZ) Serial.print("433Mhz");
  if (freq == RF12_868MHZ) Serial.print("868Mhz");
  if (freq == RF12_915MHZ) Serial.print("915Mhz"); 
  Serial.print(" Network: "); 
  Serial.println(networkGroup);
  pinMode(ledPin, OUTPUT);
  
  delay(1000);
  rf12_set_cs(10); //emonTx, emonGLCD, NanodeRF, JeeNode

  rf12_initialize(myNode, freq, networkGroup);                      
}

void loop() 
{ 

  if (rf12_recvDone()){      
      if (rf12_crc == 0 && (rf12_hdr & RF12_HDR_CTL) == 0)
      {
        int node_id = (rf12_hdr & 0x1F);
        byte n = rf12_len;
    
		if (node_id == TXnodeID)
		{
			if (rf12_data[0] >0)
				digitalWrite(ledPin, ON);
			else 
				digitalWrite(ledPin, OFF);
			Serial.println(rf12_data[0],16);
		}	
	  }	
    }
}
