/*
 RFM12B transmission checker (transmit)

Sends a 'on' message, waits, then sends an 'off' message.
Waits a while, then repeats both steps indefinitely.
Also drives an LED.
 
*/

#define WAIT1 500    // delay (ms) after sending the first message
#define WAIT2 1500   // delay (ms) after sending the second message         

#define ON HIGH
#define OFF LOW

const byte LedPin = 5;

/* frequency options are RF12_433MHZ, RF12_868MHZ or RF12_915MHZ
 */
#define freq RF12_868MHZ // Use the freq to match the module you have.

const int nodeID = 10;
                                               // emonTx RFM12B node ID
const int networkGroup = 210;
                                               // emonTx RFM12B wireless network group - needs to be same as emonBase and emonGLCD 
const int UNO = 1;
                                               // Set to 0 if you're not using the UNO bootloader (i.e using Duemilanove) 
                                               // - All Atmega's shipped from OpenEnergyMonitor come with Arduino Uno bootloader

#include <JeeLib.h>     // JeeLib is available at from: http://github.com/jcw/jeelib

typedef struct { byte dumpFlag; } PayloadStruct;    // convenient way of packaging data for RF comms
PayloadStruct payload;


void setup() 
{
  Serial.begin(9600);
  delay(7000);
  Serial.println("Transmission checker");
  Serial.print("Node: "); 
  Serial.print(nodeID); 
  Serial.print(" Freq: "); 
  if (freq == RF12_433MHZ) Serial.print("433Mhz");
  if (freq == RF12_868MHZ) Serial.print("868Mhz");
  if (freq == RF12_915MHZ) Serial.print("915Mhz"); 
  Serial.print(" Network: "); 
  Serial.println(networkGroup);
  
  rf12_initialize(nodeID, freq, networkGroup);                          // initialize RF
  rf12_sleep(RF12_SLEEP);

  pinMode(LedPin, OUTPUT);                                              // Setup indicator LED
  digitalWrite(LedPin, OFF);
  
}

void loop() 
{ 

	payload.dumpFlag = ON;
    send_rf_data();                                       
	digitalWrite(LedPin, ON);   
        Serial.println("on");
	delay(WAIT1);

	payload.dumpFlag = OFF;
    send_rf_data();                        
	digitalWrite(LedPin, OFF);   
        Serial.println("off");
	delay(WAIT2);
}

void send_rf_data()
{
  rf12_sleep(RF12_WAKEUP);
  // if ready to send + exit loop if it gets stuck as it seems too
  int i = 0; while (!rf12_canSend() && i<10) {rf12_recvDone(); i++;}
  rf12_sendStart(0, &payload, sizeof payload);
  // set the sync mode to 2 if the fuses are still the Arduino default
  // mode 3 (full powerdown) can only be used with 258 CK startup fuses
  rf12_sendWait(2);
  rf12_sleep(RF12_SLEEP);
}
