
function dialunicef_widgetlist()
{
  var widgets = {
    "dialunicef":
    {
      "offsetx":-80,"offsety":-80,"width":160,"height":160,
      "menu":"Widgets",
      "options":["feed","max","min","scale"],
      "optionstype":["feed","value","value","value","value"]
    }
  }
  return widgets;
}

function dialunicef_init()
{
  setup_widget_canvas('dialunicef');
}

function dialunicef_draw()
{
  $('.dialunicef').each(function(index)
  {
    var feed = $(this).attr("feed");
    var val = curve_value(feed,dialrate);
    // ONLY UPDATE ON CHANGE
    if ((val * 1).toFixed(2) != (assoc[feed] * 1).toFixed(2) || redraw == 1)
    {
      var id = "can-"+$(this).attr("id");
      var scale = 1*$(this).attr("scale") || 1;
      draw_gauge_unicef(widgetcanvas[id],0,0,$(this).width(),$(this).height(),val*scale, $(this).attr("max"), $(this).attr("min"), $(this).attr("units"));
    }
  });
}

function dialunicef_slowupdate()
{

}

function dialunicef_fastupdate()
{
  dialunicef_draw();
}



  function draw_gauge_unicef(ctx,x,y,width,height,position,maxvalue,minvalue,units)
  {
    if (!ctx) return; 
    maxvalue = 1 * maxvalue || 3000;
    minvalue = 1 * minvalue || 0;
    units = units || "";
    var size = 0; if (width<height) size = width/2; else size = height/2;
    size = size - (size*0.058/2);
    x = width/2; y = height/2;

    ctx.clearRect(0,0,200,200);

    if (!position) position = 0;

    var offset = 0;
    var segment = ["#0EA1C9","#95CAE9","#99E990","#41CB3C","#99E990","#E99090","#CB3C3C"];

    if (position>maxvalue) position = maxvalue;
    if (position<minvalue) position = minvalue;

    var range_position = position - minvalue;
    var range = (maxvalue - minvalue);

    var a = 1.75 - ((range_position/range) * 1.5) + offset;

  var c=3*0.785;
  var width = 0.673; 
  var pos = 0; 
  var inner = size * 0.48;

  // Segments
  for (z in segment)
  {
    ctx.fillStyle = segment[z];
    ctx.beginPath();
    ctx.arc(x,y,size,c+pos,c+pos+width+0.01,false);
    ctx.lineTo(x,y); 
    ctx.closePath();
    ctx.fill();
    pos += width;
  }
  pos -= width;
  ctx.lineWidth = (size*0.058).toFixed(0);
  pos += width;
  ctx.strokeStyle = "#fff";
  ctx.beginPath();
  ctx.arc(x,y,size,c,c+pos,false);
  ctx.lineTo(x,y); 
  ctx.closePath();
  ctx.stroke();

  ctx.fillStyle = "#666867";
  ctx.beginPath();
  ctx.arc(x,y,inner,0,Math.PI*2,true);
  ctx.closePath();
  ctx.fill();

  ctx.lineWidth = (size*0.052).toFixed(0);
  //---------------------------------------------------------------
  ctx.beginPath();
  ctx.moveTo(x+Math.sin(Math.PI*a-0.2)*inner,y+Math.cos(Math.PI*a-0.2)*inner); 
  ctx.lineTo(x+Math.sin(Math.PI*a)*size,y+Math.cos(Math.PI*a)*size); 
  ctx.lineTo(x+Math.sin(Math.PI*a+0.2)*inner,y+Math.cos(Math.PI*a+0.2)*inner); 
  ctx.arc(x,y,inner,1-(Math.PI*a-0.2),1-(Math.PI*a+5.4),true);
  ctx.closePath();
  ctx.fill();
  ctx.stroke();
  
  //---------------------------------------------------------------

  ctx.fillStyle = "#fff";
  ctx.textAlign    = "center";
  ctx.font = "bold "+(size*0.28)+"px arial";
  if (position>10) position = position.toFixed(0); else position = position.toFixed(1);
  ctx.fillText(position+units,x,y+(size*0.125));

  }


