#include "utility/font_helvB24.h"
#include "utility/font_helvB14.h"
#include "utility/font_helvB12.h"
#include "utility/font_clR4x6.h"
#include "utility/font_clR6x8.h"
  double maxcontrollertemp;
//------------------------------------------------------------------
// Draws a page showing a single power and energy value in big font
//------------------------------------------------------------------
void draw_power_page(char* powerstr, double powerval, char* energystr,  double energyval)
{ 
  glcd.clear();
  glcd.fillRect(0,0,128,64,0);
  
  char str[50];    			 //variable to store conversion 
  glcd.setFont(font_clR6x8);      
  strcpy(str,powerstr);  
  strcat(str," NOW:"); 
  glcd.drawString(0,0,str);
  strcpy(str,energystr);  
  strcat(str," TODAY:"); 
  glcd.drawString(0,38,str);

  // power value
  glcd.setFont(font_helvB24);
  itoa((int)powerval,str,10);
  strcat(str,"w");   
  glcd.drawString(3,9,str);
  
  // kwh per day value
  glcd.setFont(font_clR6x8);
  if (energyval<10.0) dtostrf(energyval,0,1,str); else itoa((int)energyval,str,10);
  strcat(str,"kWh");
  glcd.drawString(85,38,str);        
}


//------------------------------------------------------------------
// Draws the Solar import/export page
//------------------------------------------------------------------
void draw_solar_page(double use, double usekwh, double gen, double maxgen, double genkwh, double divertedpower, double controllertemp, double maxtemp, double voltage, double frequency, unsigned long last_emontx, double divertedkwh)
{
  
  int MINTEMP = -15;
  int MAXTEMP = 40;
  byte imageindex;
  double grid; //BD

  int importing = 0;

  if (use>gen) importing = 1;
  grid = use-gen; //BD
  
  glcd.clear();
  glcd.fillRect(0,0,128,64,0);
  
  glcd.drawLine(64, 0, 64, 64, WHITE);      //top vertical line
  glcd.drawLine(0, 32, 128, 32, WHITE);     //middle horizontal line 

  //variables to store conversion
  char str[50];
  char str2[5];

  // If nothing from the emonTx in the last 20 Secs then print a message
  if ((millis()-last_emontx)>20000)
  {
    // small font
    glcd.setFont(font_clR4x6);
    int emonTx_fail=(millis()-last_emontx)/1000;
    if (emonTx_fail<100){
      itoa(emonTx_fail, str, 10);
      strcat(str,"sec TxFail");
      glcd.drawString(66,0,str);
    }
    else
      glcd.drawString(66,0,PSTR("TxFail"));
    
  }

// This is where we display the cumulative diverted power in kwh

   // small font
    glcd.setFont(font_clR4x6);
    dtostrf(divertedkwh,0,1,str);
    strcat(str,"kWh today"); 
    glcd.drawString(71,34,str); // Was 67,34
/*
// If nothing from the emonbase in the last 60 Secs then print a message

  if ((millis()-last_emonbase)>120000)
  {
    // small font
    glcd.setFont(font_clR4x6);
    int emonbase_fail=((millis()-last_emonbase)/60000);
    if (emonbase_fail<100){
      itoa(emonbase_fail, str, 10);
      strcat(str,"min baseFail");
      glcd.drawString(67,34,str);
    }
    else glcd.drawString(67,34,PSTR("baseFail"));
    
  }
  */
  
  // medium font
  glcd.setFont(font_clR6x8);

  // Indicator for consuming or generating   
  glcd.drawBitmap(51,34,icon_lines_12x12,16,12,1);
  if (importing==1) glcd.drawString_P(35,34,PSTR("<<")); 
  else 
  {
    glcd.drawString_P(35,34,PSTR(">>"));
    grid=grid*-1;                                      //keep grid import/export positive - arrows change direction to indicate power flow direction
  }
  
  //big bold font
  glcd.setFont(font_helvB14);

  // Amount of power currently being used
  if(use > 1000)
  {
    dtostrf(use/1000,2,1,str);
    strcat(str,"kw");   
  }
  else
  {
    itoa((int)use,str,10);
    strcat(str,"w");   
  }  
  glcd.drawBitmap(49,0,icon_home_13x12,16,12,1);
  glcd.drawString(3,9,str);

  // Amount of energy being generated
  if(gen>1000)
  {
    dtostrf(gen/1000,2,1,str);
    strcat(str,"kw");   
  }
  else
  {
    itoa((int)gen,str,10);
    strcat(str,"w");   
  }
  //if (gen>maxgen) maxgen=gen;                  -could cause an error if any large spurious readings are detected, max gen can be set manually at beginning of sketch
  imageindex=int(gen/maxgen*5-0.5);
  glcd.drawBitmap(115,0,icon_solar_12x12[imageindex],16,12,1);
  glcd.drawString(71,9,str);

  // Amount of energy coming from or going into the grid
  if(grid<-1000 || grid>1000)
  {
    dtostrf(grid/1000,2,1,str);
    strcat(str,"kw");   
  }
  else
  {
    itoa((int)grid,str,10);
    strcat(str,"w");   
  }
  glcd.drawString(3,42,str);

  // Show diverted power

 if(divertedpower>1000)
  {
    dtostrf(divertedpower/1000,2,1,str);
    strcat(str,"kw");   
  }
  else
  {
    itoa((int)divertedpower,str,10);
    strcat(str,"w");   
  }

 
 glcd.drawBitmap(120,40,icon_divert_8x16[0],8,16,1);

  glcd.drawString(70,42,str);   

  glcd.setFont(font_clR4x6);   		//small font - Kwh

  // Kwh consumed today
  dtostrf(usekwh,0,1,str);
  strcat(str,"kWh today");  
  glcd.drawString(6,26,str);

  // Kwh generated today
  dtostrf(genkwh,0,1,str); 
  strcat(str,"kWh today");  
  glcd.drawString(71,26,str);

  // Display the current and maximum temperature of the Triac
  
  dtostrf((controllertemp/100),0,1,str); 

  glcd.drawString_P(68,58,PSTR("Tp "));
  glcd.drawString(78,58,str);
 
 // Now display maximum temperature
 
  if(controllertemp>maxcontrollertemp)
  {
    maxcontrollertemp=controllertemp;
  }
  dtostrf((maxcontrollertemp/100),0,1,str); 

  glcd.drawString_P(100,58,PSTR("Mx "));
  glcd.drawString(110,58,str);

// Mains Voltage
  glcd.drawString_P(4,58,PSTR("V "));
  itoa((int)voltage,str,10);
  glcd.drawString(10,58,str);

// Mains frequency
  glcd.drawString_P(26,58,PSTR("F "));
  dtostrf((frequency/100),2,2,str);
  glcd.drawString(32,58,str);

  // Current time
 /* glcd.drawString_P(5,58,PSTR("Time:"));
  itoa((int)hour,str,10);
  if  (minute<10) strcat(str,":0"); else strcat(str,":"); 
  itoa((int)minute,str2,10);
  strcat(str,str2); 
  glcd.drawString(28,58,str); 
*/

}




