<!----------------------------------------------------------------------------------------------------
// Flot graph php script

  // Part of the openenergymonitor.org project
  // Licence: GNU GPL
  // Last update: 26th of September
  // Author: Trystan Lea
-------------------------------------------------------------------------------------->

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<?php
$tablename = $_GET["table"];                 //Get the table name so that we know what graph to draw

?>

<html>
 <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>Graph of <?php echo $tablename; ?></title>
    <link rel="stylesheet" type="text/css" href="theme/style.css" />
    <script language="javascript" type="text/javascript" src="flot/jquery.js"></script>
    <script language="javascript" type="text/javascript" src="flot/jquery.flot.js"></script>
    <script language="javascript" type="text/javascript" src="flot/jquery.flot.selection.js"></script>
 </head>
 <body>

 <div id="bound">
   <div id="header"></div>
   <div id="box">
     <div id="topd">
       <div id="title">Graph of <?php echo $tablename; ?></div> 
       <div id="menu">
       <a href = "index.php">Input Variables</a>
       </div>
     </div>

     <div id="maintext">                                              

     <div id="placeholder" style="width:780px;height:400px;"></div>     <!-- Graph placeholder -->
 
     <p class="inc"></p>                                                <!-- Refresh counter placeholder -->
     <p class="dlen"></p>                                               <!-- Data length placeholder -->

<script id="source" language="javascript" type="text/javascript">
//--------------------------------------------------------------------------------------
var table = "<?php echo $tablename; ?>";
$(function () {
  //--------------------------------------------------------------------------------------
  // Variable declaration
  //--------------------------------------------------------------------------------------
  var inc = 0;                                      //refresh counter
  var graph_data = [];                              //data array declaration
  var placeholder = $("#placeholder");
  
  var done = 0;

  var datalength=0;                                 //Number of lines in data array
  var last_datalength=0;                            //Number of lines in data array last call

    var options = {
        xaxis: { mode: "time" },
        selection: { mode: "xy" },
    };



  fetchData();                                      //start it off!

  //--------------------------------------------------------------------------------------
  // The loop
  //--------------------------------------------------------------------------------------
  function fetchData()
  {
    //--------------------------------------------------------------------------------------
    // Fetch Data
    //--------------------------------------------------------------------------------------
    $.ajax({                                       //Using JQuery and AJAX
      url: 'getGraph.php',                         //data.php loads data to be graphed
      data: "dlen="+datalength+"&table="+table,    //
      dataType: 'json',                            //and passes it through as a JSON    
      success: function(data) 
      {
        onsuccess(data);
      } 
    });
 
    function onsuccess(data)
    {
      if (data != 0)
      {
        //--------------------------------------------------------------------------------------
        // Sort and parse data
        //--------------------------------------------------------------------------------------
        data = data.sort();                        //Switch order of array
        for (var z in data)                        //For all new lines of data
        { 
          graph_data.push(data[z]);                //add to graph_data sequentially via push
        }

        last_datalength = datalength;
        datalength = graph_data.length;
        $('.dlen').html("data length: "+datalength); 
        //--------------------------------------------------------------------------------------
        // Plot flot graph
        //--------------------------------------------------------------------------------------
        if (last_datalength<datalength)             //Only update the graph if there is new data to draw
        {
          $.plot($("#placeholder"),[                    
          {
            data: graph_data,                       //data
            lines: { show: true, fill: true }       //style
          }], 
          {
            xaxis: { mode: "time" },                 //...
            selection: { mode: "xy" },
          }); 
        }
      }

      inc++;   
      $('.inc').html("Refreshed: "+inc);            //Print number of reloads
      setTimeout(fetchData, 1000);
    }
    //--------------------------------------------------------------------------------------
  }

  //--------------------------------------------------------------------------------------
  // Graph zooming
  //--------------------------------------------------------------------------------------
  $("#placeholder").bind("plotselected", function (event, ranges) {
        // clamp the zooming to prevent eternal zoom
        if (ranges.xaxis.to - ranges.xaxis.from < 0.00001)
            ranges.xaxis.to = ranges.xaxis.from + 0.00001;
        if (ranges.yaxis.to - ranges.yaxis.from < 0.00001)
            ranges.yaxis.to = ranges.yaxis.from + 0.00001;
        
        // do the zooming
        plot = $.plot($("#placeholder"), [                    
        {
            data: graph_data,                       //data
            lines: { show: true, fill: true }       //style
        }],
        $.extend(true, {}, options, {
          xaxis: { min: ranges.xaxis.from, max: ranges.xaxis.to },
          yaxis: { min: ranges.yaxis.from, max: ranges.yaxis.to }
        }));
        
  
    });


});
//--------------------------------------------------------------------------------------
</script>

      </div>
    </div>
    <div id="footer"></div>
  </div>
  </body>
</html>  
