// A simple tool to investigate the ADC values that are seen at the 
// first four analogue inputs of an Atmega chip, as used on an emonTx
// 
// Robin Emley (calypso_rae on the Open Energy Monitor forum)
//
// 20th April 2013
//

int val_a0, val_a1, val_a2, val_a3; 
int minVal_a0, minVal_a1, minVal_a2, minVal_a3; 
int maxVal_a0, maxVal_a1, maxVal_a2, maxVal_a3;
int loopCount = 0;
unsigned long timeAtLastDisplay = 0;
byte displayLineCounter = 0;

void setup(void) 
{
  Serial.begin(9600);
  Serial.print("ready ...");
  delay(7000);
  Serial.println ();
  Serial.println(" The Min, Max and Range ADC values for analog inputs 0 to 3:");
}
 
void loop(void)
{ 
  val_a0 = analogRead(0); //  CT2
  val_a1 = analogRead(1); //  CT3
  val_a2 = analogRead(2); //  Vsensor
  val_a3 = analogRead(3); //  CT1
  
  if (val_a0 < minVal_a0) { minVal_a0 = val_a0;}
  if (val_a0 > maxVal_a0) { maxVal_a0 = val_a0;}
  if (val_a1 < minVal_a1) { minVal_a1 = val_a1;}
  if (val_a1 > maxVal_a1) { maxVal_a1 = val_a1;}
  if (val_a2 < minVal_a2) { minVal_a2 = val_a2;}
  if (val_a2 > maxVal_a2) { maxVal_a2 = val_a2;}
  if (val_a3 < minVal_a3) { minVal_a3 = val_a3;}
  if (val_a3 > maxVal_a3) { maxVal_a3 = val_a3;}
    
  unsigned long timeNow = millis();
  if ((timeNow - timeAtLastDisplay) >= 3000)
  {
    timeAtLastDisplay = timeNow;
    
    displayVal(minVal_a0); 
    displayVal(maxVal_a0);
    displayVal(maxVal_a0 - minVal_a0); 
    Serial.print(";  ");
  
    displayVal(minVal_a1); 
    displayVal(maxVal_a1);
    displayVal(maxVal_a1 - minVal_a1);
    Serial.print(";  ");
  
    displayVal(minVal_a2); 
    displayVal(maxVal_a2);
    displayVal(maxVal_a2 - minVal_a2);
    Serial.print(";  ");
  
    displayVal(minVal_a3); 
    displayVal(maxVal_a3);
    displayVal(maxVal_a3 - minVal_a3);
    Serial.println();
  
    resetMinAndMaxValues();  
    
    displayLineCounter++;
    if (displayLineCounter >= 5) 
    {
      Serial.println();
      displayLineCounter = 0;
      delay(2000); // to allow time for data to be accessed
    }
  }  
}

void resetMinAndMaxValues()
{
  minVal_a0 = 1023, minVal_a1 = 1023, minVal_a2 = 1023, minVal_a3 = 1023; 
  maxVal_a0 = 0, maxVal_a1 = 0, maxVal_a2 = 0, maxVal_a3 = 0; 
}

void displayVal(int intVal)
{
  char strVal[4];
  byte lenOfStrVal;
  
  // display the value as a right-justified integer
//  intVal = surplusPowerSetting; // apply integer rounding 
  itoa(intVal, strVal, 10); // decimal conversion to string
  lenOfStrVal = strlen(strVal); // determine length of string
             
  for (int i = 0; i < (4 - lenOfStrVal); i++) 
  {
    Serial.print(' '); 
  }
  
  Serial.print(strVal);       
}
