import oauth2 as oauth
import sys
from urllib import urlencode

# Fix for python < 2.6 compatibility
try:
    from urlparse import parse_qs
except ImportError:
    from cgi import parse_qs

base_url        = "https://auth.opera.com/service/oauth/"
consumer_key    = "test_desktop_key"
consumer_secret = "p2FlOFGr3XFm5gOwEKKDcg3CvA4pp0BC"

def get_request_token_info():
    try:
        f = open('request_token.txt', 'r')
        t = f.readline().rstrip()
        t_s = f.readline().rstrip()
        f.close()
        if t   == '': raise IOError("Request token is empty")
        if t_s == '': raise IOError("Request token secret is empty")
        return (t, t_s)
    except IOError:
        # No cached token, retrieve a new one
        consumer = oauth.Consumer(key=consumer_key, secret=consumer_secret)
        client = oauth.Client(consumer)
        body = urlencode(dict(oauth_callback="oob"))
        resp, content = client.request(base_url + "request_token", "POST", body=body)
        if resp["status"] == "200":
            data = parse_qs(content)
            t, t_s = data["oauth_token"][0], data["oauth_token_secret"][0]
            print "Now go to:\n\n%s/authorize?oauth_token=%s&oauth_callback=oob\n\nand type here the verifier code you get:" % (base_url, t)
            verifier = raw_input()
            if verifier == "":
                print "You need to write the verifier code. Please try again."
                sys.exit(1)
            f = open('request_token.txt', 'w')
            f.write("%s\n%s\n" % (t, t_s))
            f.close()
            f = open('token_verifier.txt', 'w')
            f.write(verifier)
            f.close()
            sys.exit(1)
        else:
            print content
            raise Exception("Status was " + resp["status"] + " when getting request token")


def get_access_token_info(r_t=None, r_t_s=None):
    f_verifier = open('token_verifier.txt', 'r')
    t_v = f_verifier.readline().rstrip()
    f_verifier.close()
    try:
        f = open('access_token.txt', 'r')
        a_t = f.readline().rstrip()
        a_t_s = f.readline().rstrip()
        f.close()
        if a_t   == '': raise IOError("Access token is empty")
        if a_t_s == '': raise IOError("Access token is empty")
        return (a_t, a_t_s)
    except IOError:
        # No cached token, retrieve a new one
        consumer = oauth.Consumer(key=consumer_key, secret=consumer_secret)
        request_token = oauth.Token(r_t, r_t_s)
        request_token.set_verifier(t_v)
        client = oauth.Client(consumer, request_token)
        resp, content = client.request(base_url + "access_token", "POST")
        if resp["status"]  == "200":
            data = parse_qs(content)
            a_t, a_t_s = data["oauth_token"][0], data["oauth_token_secret"][0]
            f = open('access_token.txt', 'w')
            f.write("%s\n%s\n" % (a_t, a_t_s))
            f.close()
            return (a_t, a_t_s)
        else:
            print "Status was " + resp["status"] + " when getting access token"
            print "You might want to remove request_token.txt and start all over"
            sys.exit(1)

request_token, request_token_secret = get_request_token_info()
access_token, access_token_secret = get_access_token_info(request_token,
                                                          request_token_secret)

consumer = oauth.Consumer(key=consumer_key, secret=consumer_secret)
access_token_obj = oauth.Token(access_token, access_token_secret)
client = oauth.Client(consumer, access_token_obj)
client.set_signature_method(oauth.SignatureMethod_HMAC_SHA1())

if len(sys.argv) < 2 or len(sys.argv) > 3:
    print "ERROR: Need exactly one or two parameters"
    print "SYNTAX: linkapidebugger.py <url> [get|post]"
    print "EXAMPLE: linkapidebugger.py https://link.api.opera.com/rest/bookmark/"
    sys.exit(1)

url    = sys.argv[1]
method = "GET"
data   = {}
if len(sys.argv) > 2:
    method = sys.argv[2].upper()
    # For POST requests, read from the terminal until there's an empty line
    if method == "POST":
        print "Reading extra parameters from the keyboard, one per line"
        print "(e.g. 'api_method=delete')"
        print "End with an empty line (ie. just pressing ENTER twice after your data)"
        while 1:
            line = raw_input().decode(sys.stdout.encoding).rstrip()
            if line == "": break
            var, val = line.split("=", 1)
            data[var] = val.encode("utf8")

headers = {"Accept:": "application/json"}
if method == "POST":
    body = urlencode(data)
    resp, content = client.request(url, method, body=body, headers=headers)
else:
    resp, content = client.request(url, method, headers=headers)
print "Response properties\n==================="
print resp
print "\nResponse body\n============="
print content
