/**
 * Copyright (c) 2009, Opera Software ASA
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Opera Software ASA nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY OPERA SOFTWARE ASA AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL OPERA SOFTWARE ASA AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

var squarePuzzle;
 
window.languages = 
{
    'en' : 'lang/en.js'
};
 
window.addEventListener("load", function()
{
    window.setLanguage( 'en', function()
	{
		document.toLocale();  
		squarePuzzle = new SquarePuzzle();
		var img = new Image();
		
		img.onload = function() {
			squarePuzzle.init();
		}
		img.src = "skin/on.png";	
	});
	window.addEventListener("resolution",function()
	{
	    window.onload();
	}, false);
	
} ,false);

function SquarePuzzle() {

	this.init = function(){
	
	/*
		if('handheld' == testMedia().type){
			switchSkin('handheld');
			$('bottomright').className = "bottomright_mobile";
			setFullScreen();
			Animation.on = false;
		}
		else{
			switchSkin('default');
		}
;*/		
	   // setFullScreen();
		drawBoard();
		var clicks = $("clicks");
		clicks.textContent = "Clicks".toLocale() +  "0";
		$("new").addEventListener("click", resetGame, false); //showAlert, false);
		/* $("btnYes").addEventListener("click", resetGame, false );
		$("btnNo").addEventListener("click", hideAlert, false );
		$("btnExit").addEventListener("click", function()
		{
		    window.close();
		}, false );
		$("btnNewGame").addEventListener("click", hideAlert, false ); */
		$("clicks").style.display = 'none';	
        $("new").style.display = 'none';	
        if ( screen.width >= 650 )
        { 
            $('start').style.left = "18%";
			$('restart').style.left = "18%";
        } 		
        $("start").addEventListener("click", function()
		{
			$('startPage').style.display = 'none';
			$("clicks").style.display = 'block';	
			$("new").style.display = 'block';	
		}, false);	
        $('restart').addEventListener("click", function()
		{
			$('winPage').style.display = 'none';
			resetGame();
		}, false);			
	}
	
	function drawBoard() {
	    var tbl = $("sqContainer"), i, j, tr, td;
		for(i=0; i < 5; i++)
		{
			tr = document.createElement("tr");
			tr.id = "row" + i; 
			for(j=0; j < 5; j++)
			{
				td = document.createElement("td");
				// set id of the column
				td.id = "col" + j;
				td.className = 'off';
				// add click event
				td.addEventListener("click", switchState ,false);
				// add column to the row
				tr.appendChild(td);
			}
			// add row to the table
			tbl.appendChild(tr);
		}
	}

	function $(ele){
		return document.getElementById(ele);
	}
 
	function switchState(){
		var td, sq = this;
		
		// increase click status
		var clicks = $("clicks");
		clicks.textContent = 'Clicks'.toLocale() + (parseInt(clicks.firstChild.nodeValue.substr(7)) + 1);
		opera.postError(clicks.textContent.substr(7), clicks.textContent);
		// for the current col
		setBackground(sq);

		// for prev row
		td = getTd(sq, -1, 0);
		if(td)
			setBackground(td);
		
		// for next row
		td = getTd(sq, 1, 0);
		if(td)
			setBackground(td);
		
		// for prev col 
		td = getTd(sq, 0, -1);
		if(td)
			setBackground(td);

		// for next col
		td = getTd(sq, 0, 1);
		if(td)
			setBackground(td);
			
		if(winStatus()){
			showWinpage();
		}

	}

	function showWinpage()
	{
	    $('winPage').style.display = 'block';
		$("clicks").style.display = 'none';	
		$("new").style.display = 'none';
        $('winmsg').textContent = 'winmsg'.toLocale();
        $('winText').textContent = 'winText1'.toLocale() + 	clicks.textContent.substr(7) + 'winText2'.toLocale();	
	}
	
	function getTd(sq, row, col){
		try{
			return $("row" + (parseInt(sq.parentNode.id.substr(3)) + row )).childNodes[ parseInt(sq.id.substr(3)) + col];
		}catch(e){ return null; }
	}

	function setBackground(sq){
			(sq.className == "on")? 
			(sq.className = "off"):
			(sq.className = 'on');
	}

	function winStatus(){
				
		var cols = document.getElementsByTagName("td");
		
		for(i=0; i < cols.length; i++ ){
			if ( cols[i].className == 'off' )
				return false;	
		}
		
		return true;
	}

	function resetGame(){
		
		$("clicks").innerHTML = "Clicks".toLocale() + '0';
		
		var cols = document.getElementsByTagName("td");
		
		for(i=0; i < cols.length; i++ )
		{
		    cols[i].className  ='off';
		}  
	//	hideAlert();			
			
	}

	/*function showAlert(msg){
		
		var msgSpan, anim, anim1;
		
		if(this.id == "new"){
			msg = "Give up?";
			$("btnYes").style.display = "inline";
			$("btnNo").style.display = "inline";
			$("btnNewGame").style.display = "none";		
		}
		else{
			$("btnYes").style.display = "none";
			$("btnNo").style.display = "none";		
			$("btnNewGame").style.display = "inline";
		}
			
		
		msgSpan = $("msg");
		msgSpan.innerHTML = 'msg'.toLocale();
		

		// add animation to msgbox div
		$("msgbox").style.opacity = "0";
		$("msgbox").style.display = "block";
		anim = $("msgbox").createAnimation();
		anim.speed = 20;
		anim.onfinish = function() {
			$("msgbox").style.opacity = 1;
		}
		anim.addAnimation("opacity", 0, 0.6).run();
		
		
		anim1 = $("new").createAnimation();
		anim1.speed = 20;
		anim1.onfinish = function() {
			$("new").style.opacity = "0.4";
		}
		anim1.addAnimation("opacity", 1, 0).run();
		
	}

	function hideAlert(){
		var anim, anim1;
		
		// add animation to msgbox div
		anim = $("msgbox").createAnimation();
		anim.speed = 20;
		anim.onfinish = function(){
			$("msgbox").style.display = "none";
		}
		anim.addAnimation("opacity", 0.6, 0).run();

		
		$("new").style.opacity = 0;
		$("new").style.display = "block";
		anim1 = $("new").createAnimation();
		anim1.speed = 20;
		anim1.addAnimation("opacity", 0, 1).run();
		
		if(this.id == "btnNewGame")
			resetGame();
	}

	function setFullScreen(){
		// fix wrapper height and width
		window.moveTo(0, 0);
		window.resizeTo(screen.availWidth, screen.availHeight);
			
		window.scrollTo(0,0);
		document.body.style.top = "0px";
		document.body.style.left = "0px";
		
		document.body.style.width = window.innerWidth + "px";
		document.body.style.height = window.innerHeight + "px";
		
		var w = $('wrapper');
		w.style.width = document.body.clientWidth + "px";
		w.style.height = document.body.clientHeight + "px";
		
		$('container').style.left = Math.floor( (document.body.clientWidth -$('container').offsetWidth ) / 2) + "px";
		$('centerleft').style.height = $('centerright').style.height = $('container').offsetHeight + 'px';
		
	}
	
	function switchSkin (title) 
	{
		var stylesheets = document.getElementsByTagName("link");
		var x, stylesheet;
		for(x=1; x < stylesheets.length; x++) {
			stylesheet = stylesheets[x];
			if(stylesheet.getAttribute("rel").indexOf("stylesheet") != -1) {
				stylesheet.disabled = true;
				if(stylesheet.getAttribute("title") == title) stylesheet.disabled = false;
			}
		}
	}*/
}
