// define a namespace to hold our widget specific functions,
// avoid polluting the global namespace
var helloWorld = helloWorld || {};

// function for flipping between different sides of the widget
helloWorld.flip = function ( e )
{
    var display = document.getElementById('front').style.display;
    if ( display == 'block' || display == '' )
    {
        document.getElementById('front').style.display = "none";
        document.getElementById('config').style.display = "block";
    }
    else
    {
        document.getElementById('config').style.display = "none";
        document.getElementById('front').style.display = "block";
    }
}

// initialize the widget
window.addEventListener( 'load' , function(ev)
{
    // add behavior to the flip button
    document.getElementById('flipbutton').addEventListener('click',function(ev){
        helloWorld.flip();
    }, false);

    // add a change handler so that the widget shows whatever we input into the 
    // widget front, flip back to the front when done
    document.getElementById('updatebutton').addEventListener('click',function(ev){
        document.getElementById('hellotext').textContent = 
            document.getElementById('frontlabel').value;
        helloWorld.flip();
    },false);
  
    // set the contents of the text field to the initial value
    document.getElementById('frontlabel').setAttribute( 'value',
        document.getElementById('hellotext').textContent );
},false);







