opera.io.webserver.addEventListener( '_request', handleRequest, false );

function handleRequest( event )
{
    var response = event.connection.response;
    
    var data =
    {
        name    : 'Template',
        func    : function foo()
        {
            var baz = 3;

            return 'bar';
        }
    };
    var template = new Markuper( 'templates/tutorial.html', data );
    
    template.registerDataAttribute( 'list-code', function( node, data, key, value )
    {
        var keywords = ['function', 'var', 'return'];
        var regexp = new RegExp( keywords.join('|'), 'g' );
        value = value.toString().replace( regexp, function( keyword )
        {
            return '<span style="color: blue">' + keyword + '</span>';
        });
        node.innerHTML = value;
    });
    
    response.write( template.parse().html() );
    response.close();
}