/* Code by David Storey, Vadim Makeev and Patrick H. Lauke */

function addEventListeners() {

	//ID test buttons
	var button = document.getElementById('id-dom');
	button.addEventListener('click', function () { 
		var el = document.getElementById('id-test');
		removeClass(el, 'select-active');
		toggleClass(el, 'dom-active');
	}, false);
	
	button = document.getElementById('id-select');
	button.addEventListener('click', function () {
		var el = document.querySelector('#id-test');
		removeClass(el, 'dom-active');
		toggleClass(el, 'select-active');
	}, false);
	
	//Class test buttons
	button = document.getElementById('class-dom');
	button.addEventListener('click', function () {
		//get all elements with class 'class-test' and pass the first one (there is only one in this example).
		var el = document.getElementsByClassName('class-test');
		removeClass(el[0], 'select-active');
		toggleClass(el[0], 'dom-active');
	}, false);
	
	button = document.getElementById('class-select');
	button.addEventListener('click', function () {
		//if querySelector is used and multiple elements are selected, only the first found is returned.
		var el = document.querySelector('.class-test');
		removeClass(el, 'dom-active');
		toggleClass(el, 'select-active');
	}, false);
	
	//Position/tag test buttons
	button = document.getElementById('tagname-dom');
	button.addEventListener('click', function () {
		//get all of the sections then get the 1st p element of the third section
		var temp = document.getElementsByTagName('section');
		var el = temp[2].getElementsByTagName('p');
		removeClass(el[0], 'select-active');
		toggleClass(el[0], 'dom-active');
	}, false);
	
	button = document.getElementById('tagname-select');
	button.addEventListener('click', function () {
		var el = document.querySelector('section:nth-of-type(3) p');
		removeClass(el, 'dom-active');
		toggleClass(el, 'select-active');
	}, false);
	
	//Attribute test buttons
	button = document.getElementById('attribute-dom');
	button.addEventListener('click', function () {
		var paras = document.getElementsByTagName('p');
		var el;
		for (var i=0;i<paras.length;i++) {
			//the first element that has a attribute aria-disabled='false' 
			if (paras[i].getAttribute('aria-disabled') == 'true' && !el) {
				el = paras[i];
			}
		}
		removeClass(el, 'select-active');
		toggleClass(el, 'dom-active');	
	}, false);
	
	button = document.getElementById('attribute-select');
	button.addEventListener('click', function () {
		var el = document.querySelector("p[aria-disabled='true']");
		removeClass(el, 'dom-active');
		toggleClass(el, 'select-active');	
	}, false);
	
	//Mutliple pseudo-class test buttons
	button = document.getElementById('pseudo-dom');
	button.addEventListener('click', function () {
		var temp = document.getElementsByTagName('section');
		var el = temp[4].getElementsByTagName('p');
		removeClass(el[0], 'select-active');
		toggleClass(el[0], 'dom-active');
		removeClass(el[el.length - 1], 'select-active');
		toggleClass(el[el.length - 1], 'dom-active');	
	}, false);
	
	button = document.getElementById('pseudo-select');
	button.addEventListener('click', function () {
		var el = document.querySelectorAll('section:nth-of-type(5) p:first-of-type, section:nth-of-type(5) p:last-of-type');
		for (var i=0;i<el.length;i++) {
			removeClass(el[i], 'dom-active');
	   	 	toggleClass(el[i], 'select-active');
		}	
	}, false);
	
	//Mutliple pseudo-class test buttons
	button = document.getElementById('pseudo-all-dom');
	button.addEventListener('click', function () {
		var temp = document.getElementsByTagName('section');
		var el = temp[5].getElementsByTagName('li');
		for (var i=0;i<el.length;i +=2) {
			removeClass(el[i], 'select-active');
			toggleClass(el[i], 'dom-active');
		}	
	}, false);
	
	button = document.getElementById('pseudo-all-select');
	button.addEventListener('click', function () {
		var el = document.querySelectorAll('section:nth-of-type(6) li:nth-child(odd)');
		for (var i=0;i<el.length;i++) {
			removeClass(el[i], 'dom-active');
			toggleClass(el[i], 'select-active');
		}	
	}, false);

}

/* class handling functions */

function hasClass(el,type) {
	return el.className.match(new RegExp('(\\s|^)'+type+'(\\s|$)'));
}

function addClass(el,type) {
	if (!this.hasClass(el,type)) el.className += ' '+type;
}

function removeClass(el,type) {
	if (hasClass(el,type)) {
		var reg = new RegExp('(\\s|^)'+type+'(\\s|$)');
		el.className=el.className.replace(reg,' ');
	}
}

function toggleClass(el, type) {
    if (hasClass(el,type)) {
		removeClass(el, type);
	} else {
		addClass(el, type);
	}
}

window.addEventListener('load', addEventListeners, false);