// For encapsulation purposes
function TestCode()
{
    // Create a Framerate object
    this.f = new Framerate();
    
    // Initialize Framerate object
    this.f.setRate(10);
    this.f.reset();
    
    // Create <p> object inside the page
    this.p_obj = document.createElement("p");
    this.p_obj.innerHTML = "0.0 seconds";
    document.body.appendChild(this.p_obj);
    
    // Reset seconds counter
    this.seconds = 0;
    
    // This function will be called constantly to update the counter in the
    // <p> object in the page.
    this.callback = function()
    {
        // Get amount of frames elapsed
        var numFrames = this.f.getFrames();
        
        // Update amount of seconds
        this.seconds += numFrames / 10;
        
        // Show seconds on screen
        this.p_obj.innerHTML = Math.floor(this.seconds) + "." +
                               Math.floor(this.seconds * 10) % 10 +
                               " seconds";
    }
    
    // Call updating function
    var myself = this;
    setInterval(myself.callback, 150);
}


// Call the function :O)
TestCode();
