URLs([
    '_index', spreadsheet,
    'spreadsheet_update', spreadsheet_update,
    'spreadsheet_set_cell', spreadsheet_set_cell,
    'list_files', list_files,
]); 

db_handles = {};
function db_handle(db_name) {
	if(!db_handles[db_name]) {
		db_handles[db_name] = new JSON_FILE(db_name, {
			values:{ 
				//A1:'test' 
			},
			updates:[
				//[1245785592.5, 'C3', 'soft update'],
			],
		});
	};
	return db_handles[db_name];
};

function spreadsheet_set_cell(r) {
	if(r.GET.cell_id) {
		if (r.GET.cell_id.match(/^[A-Z]{1,2}[0-9]+$/)) {
			//r.write("alert('"+(r.GET.cell_id.match(/^[A-Z][0-9]+$/))+"');");
			r.GET.value = UTF8.decode(r.GET.value);
			db_handle(current_page(r)).store.values[r.GET.cell_id] = r.GET.value;
			db_handle(current_page(r)).store.updates.push([(new Date()).getTime()/1000, r.GET.cell_id, r.GET.value]);

			db_handle(current_page(r)).store.updates = db_handle(current_page(r)).store.updates.filter(
				function(i){
					return i[0]>((new Date()).getTime()/1000)-1800;
				}
			);

			db_handle(current_page(r)).save();
		};
	};
};

function spreadsheet_update(r) {
	db_handle(current_page(r)).store.updates.forEach(function(i) {
		if(i[0] && i[0]>=r.GET.since) {
			r.write('set_cell_value('+safe_js_val(i[1])+', '+safe_js_val(i[2])+');\n');
		};
	});
	r.write("current_time = "+(new Date()).getTime()/1000+";");
};

function current_page(r) {
	return UTF8.decode( r.GET.filename ? r.GET.filename : 'spreadsheet.json' );
};

function spreadsheet(r) {
	template = new Markuper('templates/index.html', {
		base: r.uri('/'),
		current_time: (new Date()).getTime()/1000,
		current_page: safe_js_val(current_page(r)),
	});


	init_script = '';
	init_script += 'page_loaded = 0; ';
	table = '<table>';
	table += '<tr><td style="background: transparent;">';

	for(var j=1;j<20;j++) {
		table += '<td class="header">'+j;
	};

	for(var i=0;i<30;i++) {
		if(i>25) {
			A = String.fromCharCode(65-1+Math.floor(i/26)) + String.fromCharCode(65+i%26);
		} else {
			A = String.fromCharCode(65+i);
		};
		table += '<tr><td class="header">'+A;
		for(var j=1;j<20;j++) {
			var _value = (A+j in db_handle(current_page(r)).store.values) ? db_handle(current_page(r)).store.values[A+j] : "";
			table += '<td class="cell" id="CELL_'+A+j+'">';
			//table += _value;
			if(_value) {
				init_script += 'set_cell_value('+safe_js_val(A+j)+', '+safe_js_val(_value)+');';
			};

		};
	};
	table += '</table>';
	init_script += 'page_loaded = 1; $(document).ready(function(){ evaluate_cells(); }); ';

	template.select('#main_table')[0].innerHTML = table;
	template.select('body')[0].innerHTML += '<scr'+'ipt>$(document).ready(function(){' + init_script + '});</scr'+'ipt>';

	r.write(template.parse().html());
};

function list_files(r) {
	r.write(JSON.stringify(glob('storage')));
};